/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.info;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.data.info.InfoData;
import me.jfenn.attribouter.dialogs.UserDialog;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.utils.UrlClickListener;

public class ContributorInfoData
extends InfoData<ViewHolder> {
    @Nullable
    public String login;
    @Nullable
    public String name;
    @Nullable
    public String avatarUrl;
    @Nullable
    public String bio;
    @Nullable
    public String blog;
    @Nullable
    public String email;
    @Nullable
    Integer position;
    @Nullable
    public String task;
    boolean isHidden;

    ContributorInfoData(@Nullable String login, @Nullable String name, @Nullable String avatarUrl, @Nullable String task, @Nullable Integer position, @Nullable String bio, @Nullable String blog, @Nullable String email) {
        super(R.layout.item_attribouter_contributor);
        this.login = login;
        this.name = name;
        this.avatarUrl = avatarUrl;
        this.task = task;
        this.position = position;
        this.bio = bio;
        this.blog = blog;
        this.email = email;
    }

    @Nullable
    public String getName() {
        return this.name != null ? this.name : this.login;
    }

    public void merge(ContributorInfoData contributor) {
        if (!(this.name != null && this.name.startsWith("^") || contributor.name == null)) {
            this.name = contributor.name;
        }
        if (!(this.avatarUrl != null && this.avatarUrl.startsWith("^") || contributor.avatarUrl == null)) {
            this.avatarUrl = contributor.avatarUrl;
        }
        if (!(this.bio != null && this.bio.startsWith("^") || contributor.bio == null || contributor.bio.isEmpty())) {
            this.bio = contributor.bio;
        }
        if (!(this.blog != null && this.blog.startsWith("^") || contributor.blog == null || contributor.blog.isEmpty())) {
            this.blog = contributor.blog;
        }
        if (!(this.task != null && this.task.startsWith("^") || contributor.task == null)) {
            this.task = contributor.task;
        }
    }

    public boolean hasEverything() {
        return this.name != null && this.name.startsWith("^") && this.bio != null && this.bio.startsWith("^") && this.blog != null && this.blog.startsWith("^");
    }

    public boolean equals(Object obj) {
        return obj instanceof ContributorInfoData && (this.login != null ? this.login.equals(((ContributorInfoData)obj).login) : super.equals(obj));
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        ResourceUtils.setImage(context, this.avatarUrl, viewHolder.imageView);
        viewHolder.nameView.setText((CharSequence)ResourceUtils.getString(context, this.getName()));
        if (this.task != null) {
            viewHolder.taskView.setVisibility(0);
            viewHolder.taskView.setText((CharSequence)ResourceUtils.getString(context, this.task));
        } else {
            viewHolder.taskView.setVisibility(8);
        }
        String blog = ResourceUtils.getString(context, this.blog);
        if (this.bio != null) {
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    new UserDialog(view.getContext(), ContributorInfoData.this).show();
                }
            });
        } else if (blog != null) {
            viewHolder.itemView.setOnClickListener((View.OnClickListener)new UrlClickListener(blog));
        } else {
            viewHolder.itemView.setOnClickListener(null);
        }
    }

    static class ViewHolder
    extends InfoData.ViewHolder {
        private ImageView imageView;
        private TextView nameView;
        private TextView taskView;

        ViewHolder(View v) {
            super(v);
            this.imageView = (ImageView)v.findViewById(R.id.image);
            this.nameView = (TextView)v.findViewById(R.id.name);
            this.taskView = (TextView)v.findViewById(R.id.task);
        }
    }
}

