/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.info;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.data.github.RepositoryData;
import me.jfenn.attribouter.data.info.InfoData;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.utils.UrlClickListener;

public class AppInfoData
extends InfoData<ViewHolder> {
    private String repo;
    private String icon;
    private String description;
    private String playStoreUrl;
    private String websiteUrl;
    private String gitHubUrl;
    private boolean isPlayStore;

    public AppInfoData(XmlResourceParser parser) {
        super(R.layout.item_attribouter_app_info);
        this.repo = parser.getAttributeValue(null, "repo");
        this.icon = parser.getAttributeValue(null, "icon");
        this.description = parser.getAttributeValue(null, "description");
        this.playStoreUrl = parser.getAttributeValue(null, "playStoreUrl");
        this.isPlayStore = parser.getAttributeBooleanValue(null, "showPlayStoreUrl", true);
        this.websiteUrl = parser.getAttributeValue(null, "websiteUrl");
        this.gitHubUrl = parser.getAttributeValue(null, "gitHubUrl");
        if (this.gitHubUrl == null && this.repo != null) {
            this.gitHubUrl = "https://github.com/" + this.repo;
        }
        this.addRequest(new RepositoryData(this.repo));
    }

    @Override
    public void onInit(GitHubData data) {
        if (data instanceof RepositoryData) {
            RepositoryData repository = (RepositoryData)data;
            if (!(this.description != null && this.description.startsWith("^") || repository.description == null)) {
                this.description = repository.description;
            }
            if (!(this.gitHubUrl != null && this.gitHubUrl.startsWith("^") || repository.html_url == null)) {
                this.gitHubUrl = repository.html_url;
            }
            if (!(this.websiteUrl != null && this.websiteUrl.startsWith("^") || repository.homepage == null)) {
                if (repository.homepage.startsWith("https://play.google.com/")) {
                    if (this.playStoreUrl == null || !this.playStoreUrl.startsWith("^")) {
                        this.playStoreUrl = repository.homepage;
                    }
                } else {
                    this.websiteUrl = repository.homepage;
                }
            }
        }
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        ApplicationInfo info = context.getApplicationInfo();
        ResourceUtils.setImage(context, this.icon, info.icon, viewHolder.appIconView);
        viewHolder.nameTextView.setText(info.labelRes);
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(info.packageName, 0);
            viewHolder.versionTextView.setText((CharSequence)String.format(context.getString(R.string.title_attribouter_version), packageInfo.versionName));
            viewHolder.versionTextView.setVisibility(0);
        }
        catch (PackageManager.NameNotFoundException e) {
            viewHolder.versionTextView.setVisibility(8);
        }
        if (this.description != null) {
            viewHolder.descriptionTextView.setVisibility(0);
            viewHolder.descriptionTextView.setText((CharSequence)ResourceUtils.getString(context, this.description));
        } else {
            viewHolder.descriptionTextView.setVisibility(8);
        }
        if (this.isPlayStore) {
            UrlClickListener listener = new UrlClickListener("https://play.google.com/store/apps/details?id=" + info.packageName);
            if (this.playStoreUrl != null) {
                listener = new UrlClickListener(ResourceUtils.getString(context, this.playStoreUrl));
            }
            viewHolder.playStoreButton.setVisibility(0);
            viewHolder.playStoreButton.setOnClickListener((View.OnClickListener)listener);
        } else {
            viewHolder.playStoreButton.setVisibility(8);
        }
        if (this.websiteUrl != null) {
            viewHolder.websiteButton.setVisibility(0);
            viewHolder.websiteButton.setOnClickListener((View.OnClickListener)new UrlClickListener(ResourceUtils.getString(context, this.websiteUrl)));
        } else {
            viewHolder.websiteButton.setVisibility(8);
        }
        if (this.gitHubUrl != null) {
            viewHolder.gitHubButton.setVisibility(0);
            viewHolder.gitHubButton.setOnClickListener((View.OnClickListener)new UrlClickListener(ResourceUtils.getString(context, this.gitHubUrl)));
        } else {
            viewHolder.gitHubButton.setVisibility(8);
        }
    }

    static class ViewHolder
    extends InfoData.ViewHolder {
        ImageView appIconView;
        TextView nameTextView;
        TextView versionTextView;
        TextView descriptionTextView;
        View websiteButton;
        View gitHubButton;
        View playStoreButton;

        private ViewHolder(View v) {
            super(v);
            this.appIconView = (ImageView)v.findViewById(R.id.appIcon);
            this.nameTextView = (TextView)v.findViewById(R.id.appName);
            this.versionTextView = (TextView)v.findViewById(R.id.appVersion);
            this.descriptionTextView = (TextView)v.findViewById(R.id.description);
            this.websiteButton = v.findViewById(R.id.appLinkWebsite);
            this.gitHubButton = v.findViewById(R.id.appLinkGitHub);
            this.playStoreButton = v.findViewById(R.id.appLinkPlayStore);
        }
    }
}

