/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.rxerrorhandler.handler;

import android.util.Log;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Function;
import java.util.concurrent.TimeUnit;

public class RetryWithDelay
implements Function<Observable<Throwable>, ObservableSource<?>> {
    public final String TAG = this.getClass().getSimpleName();
    private final int maxRetries;
    private final int retryDelaySecond;
    private int retryCount;

    public RetryWithDelay(int maxRetries, int retryDelaySecond) {
        this.maxRetries = maxRetries;
        this.retryDelaySecond = retryDelaySecond;
    }

    public ObservableSource<?> apply(@NonNull Observable<Throwable> throwableObservable) throws Exception {
        return throwableObservable.flatMap(new Function<Throwable, ObservableSource<?>>(){

            public ObservableSource<?> apply(@NonNull Throwable throwable) throws Exception {
                if (++RetryWithDelay.this.retryCount <= RetryWithDelay.this.maxRetries) {
                    Log.d((String)RetryWithDelay.this.TAG, (String)("Observable get error, it will try after " + RetryWithDelay.this.retryDelaySecond + " second, retry count " + RetryWithDelay.this.retryCount));
                    return Observable.timer((long)RetryWithDelay.this.retryDelaySecond, (TimeUnit)TimeUnit.SECONDS);
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }
}

