/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.rxerrorhandler.handler;

import android.util.Log;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

public class RetryWithDelay
implements Func1<Observable<? extends Throwable>, Observable<?>> {
    public final String TAG = this.getClass().getSimpleName();
    private final int maxRetries;
    private final int retryDelaySecond;
    private int retryCount;

    public RetryWithDelay(int maxRetries, int retryDelaySecond) {
        this.maxRetries = maxRetries;
        this.retryDelaySecond = retryDelaySecond;
    }

    public Observable<?> call(Observable<? extends Throwable> attempts) {
        return attempts.flatMap(new Func1<Throwable, Observable<?>>(){

            public Observable<?> call(Throwable throwable) {
                if (++RetryWithDelay.this.retryCount <= RetryWithDelay.this.maxRetries) {
                    Log.d((String)RetryWithDelay.this.TAG, (String)("get error, it will try after " + RetryWithDelay.this.retryDelaySecond + " second, retry count " + RetryWithDelay.this.retryCount));
                    return Observable.timer((long)RetryWithDelay.this.retryDelaySecond, (TimeUnit)TimeUnit.SECONDS);
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }
}

