/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.rxerrorhandler.core;

import android.content.Context;
import me.jessyan.rxerrorhandler.handler.ErrorHandlerFactory;
import me.jessyan.rxerrorhandler.handler.listener.ResponseErroListener;

public class RxErrorHandler {
    public final String TAG = this.getClass().getSimpleName();
    private ErrorHandlerFactory mHandlerFactory;

    private RxErrorHandler(Builder builder) {
        this.mHandlerFactory = builder.errorHandlerFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ErrorHandlerFactory getmHandlerFactory() {
        return this.mHandlerFactory;
    }

    public static final class Builder {
        private Context context;
        private ResponseErroListener responseErroListener;
        private ErrorHandlerFactory errorHandlerFactory;

        private Builder() {
        }

        public Builder with(Context context) {
            this.context = context;
            return this;
        }

        public Builder responseErroListener(ResponseErroListener responseErroListener) {
            this.responseErroListener = responseErroListener;
            return this;
        }

        public RxErrorHandler build() {
            if (this.context == null) {
                throw new IllegalStateException("context is required");
            }
            if (this.responseErroListener == null) {
                throw new IllegalStateException("responseErroListener is required");
            }
            this.errorHandlerFactory = new ErrorHandlerFactory(this.context, this.responseErroListener);
            return new RxErrorHandler(this);
        }
    }
}

