/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.autosize.external;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.jessyan.autosize.external.ExternalAdaptInfo;
import me.jessyan.autosize.utils.Preconditions;

public class ExternalAdaptManager {
    private List<String> mCancelAdaptList;
    private Map<String, ExternalAdaptInfo> mExternalAdaptInfos;
    private boolean isRun;

    public synchronized ExternalAdaptManager addCancelAdaptOfActivity(Class<?> activityClass) {
        Preconditions.checkNotNull(activityClass, "activityClass == null");
        if (!this.isRun) {
            this.isRun = true;
        }
        if (this.mCancelAdaptList == null) {
            this.mCancelAdaptList = new ArrayList<String>();
        }
        this.mCancelAdaptList.add(activityClass.getCanonicalName());
        return this;
    }

    public synchronized ExternalAdaptManager addExternalAdaptInfoOfActivity(Class<?> activityClass, ExternalAdaptInfo info) {
        Preconditions.checkNotNull(activityClass, "activityClass == null");
        if (!this.isRun) {
            this.isRun = true;
        }
        if (this.mExternalAdaptInfos == null) {
            this.mExternalAdaptInfos = new HashMap<String, ExternalAdaptInfo>(16);
        }
        this.mExternalAdaptInfos.put(activityClass.getCanonicalName(), info);
        return this;
    }

    public synchronized boolean isCancelAdapt(Class<?> activityClass) {
        Preconditions.checkNotNull(activityClass, "activityClass == null");
        if (this.mCancelAdaptList == null) {
            return false;
        }
        return this.mCancelAdaptList.contains(activityClass.getCanonicalName());
    }

    public synchronized ExternalAdaptInfo getExternalAdaptInfoOfActivity(Class<?> activityClass) {
        Preconditions.checkNotNull(activityClass, "activityClass == null");
        if (this.mExternalAdaptInfos == null) {
            return null;
        }
        return this.mExternalAdaptInfos.get(activityClass.getCanonicalName());
    }

    public boolean isRun() {
        return this.isRun;
    }

    public void setRun(boolean run) {
        this.isRun = run;
    }
}

