/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.autosize;

import android.app.Activity;
import android.util.DisplayMetrics;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.jessyan.autosize.AutoSizeConfig;
import me.jessyan.autosize.DisplayMetricsInfo;
import me.jessyan.autosize.external.ExternalAdaptInfo;
import me.jessyan.autosize.internal.CustomAdapt;
import me.jessyan.autosize.utils.LogUtils;
import me.jessyan.autosize.utils.Preconditions;

public final class AutoSize {
    private static Map<String, DisplayMetricsInfo> mCache = new ConcurrentHashMap<String, DisplayMetricsInfo>();

    private AutoSize() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static void autoConvertDensityOfGlobal(Activity activity) {
        if (AutoSizeConfig.getInstance().isBaseOnWidth()) {
            AutoSize.autoConvertDensityBaseOnWidth(activity, AutoSizeConfig.getInstance().getDesignWidthInDp());
        } else {
            AutoSize.autoConvertDensityBaseOnHeight(activity, AutoSizeConfig.getInstance().getDesignHeightInDp());
        }
    }

    public static void autoConvertDensityOfCustomAdapt(Activity activity, CustomAdapt customAdapt) {
        Preconditions.checkNotNull(customAdapt, "customAdapt == null");
        float sizeInDp = customAdapt.getSizeInDp();
        if (sizeInDp <= 0.0f) {
            sizeInDp = customAdapt.isBaseOnWidth() ? (float)AutoSizeConfig.getInstance().getDesignWidthInDp() : (float)AutoSizeConfig.getInstance().getDesignHeightInDp();
        }
        AutoSize.autoConvertDensity(activity, sizeInDp, customAdapt.isBaseOnWidth());
    }

    public static void autoConvertDensityOfExternalAdaptInfo(Activity activity, ExternalAdaptInfo externalAdaptInfo) {
        Preconditions.checkNotNull(externalAdaptInfo, "externalAdaptInfo == null");
        float sizeInDp = externalAdaptInfo.getSizeInDp();
        if (sizeInDp <= 0.0f) {
            sizeInDp = externalAdaptInfo.isBaseOnWidth() ? (float)AutoSizeConfig.getInstance().getDesignWidthInDp() : (float)AutoSizeConfig.getInstance().getDesignHeightInDp();
        }
        AutoSize.autoConvertDensity(activity, sizeInDp, externalAdaptInfo.isBaseOnWidth());
    }

    public static void autoConvertDensityBaseOnWidth(Activity activity, float designWidthInDp) {
        AutoSize.autoConvertDensity(activity, designWidthInDp, true);
    }

    public static void autoConvertDensityBaseOnHeight(Activity activity, float designHeightInDp) {
        AutoSize.autoConvertDensity(activity, designHeightInDp, false);
    }

    public static void autoConvertDensity(Activity activity, float sizeInDp, boolean isBaseOnWidth) {
        Preconditions.checkNotNull(activity, "activity == null");
        String key = sizeInDp + "|" + isBaseOnWidth + "|" + AutoSizeConfig.getInstance().isUseDeviceSize() + "|" + AutoSizeConfig.getInstance().getInitScaledDensity();
        DisplayMetricsInfo displayMetricsInfo = mCache.get(key);
        float targetDensity = 0.0f;
        int targetDensityDpi = 0;
        float targetScaledDensity = 0.0f;
        if (displayMetricsInfo == null) {
            targetDensity = isBaseOnWidth ? (float)AutoSizeConfig.getInstance().getScreenWidth() * 1.0f / sizeInDp : (float)AutoSizeConfig.getInstance().getScreenHeight() * 1.0f / sizeInDp;
            targetScaledDensity = targetDensity * (AutoSizeConfig.getInstance().getInitScaledDensity() * 1.0f / AutoSizeConfig.getInstance().getInitDensity());
            targetDensityDpi = (int)(targetDensity * 160.0f);
            mCache.put(key, new DisplayMetricsInfo(targetDensity, targetDensityDpi, targetScaledDensity));
        } else {
            targetDensity = displayMetricsInfo.density;
            targetDensityDpi = displayMetricsInfo.densityDpi;
            targetScaledDensity = displayMetricsInfo.scaledDensity;
        }
        AutoSize.setDensity(activity, targetDensity, targetDensityDpi, targetScaledDensity);
        LogUtils.d(String.format(Locale.ENGLISH, "The %s has been adapted! \n%s Info: isBaseOnWidth = %s, %s = %f, targetDensity = %f, targetScaledDensity = %f, targetDensityDpi = %d", activity.getClass().getName(), activity.getClass().getSimpleName(), isBaseOnWidth, isBaseOnWidth ? "designWidthInDp" : "designHeightInDp", Float.valueOf(sizeInDp), Float.valueOf(targetDensity), Float.valueOf(targetScaledDensity), targetDensityDpi));
    }

    public static void cancelAdapt(Activity activity) {
        AutoSize.setDensity(activity, AutoSizeConfig.getInstance().getInitDensity(), AutoSizeConfig.getInstance().getInitDensityDpi(), AutoSizeConfig.getInstance().getInitScaledDensity());
    }

    private static void setDensity(Activity activity, float density, int densityDpi, float scaledDensity) {
        DisplayMetrics activityDisplayMetrics = activity.getResources().getDisplayMetrics();
        DisplayMetrics appDisplayMetrics = AutoSizeConfig.getInstance().getApplication().getResources().getDisplayMetrics();
        activityDisplayMetrics.density = density;
        activityDisplayMetrics.densityDpi = densityDpi;
        activityDisplayMetrics.scaledDensity = scaledDensity;
        appDisplayMetrics.density = density;
        appDisplayMetrics.densityDpi = densityDpi;
        appDisplayMetrics.scaledDensity = scaledDensity;
    }
}

