/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.integration.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.jessyan.art.integration.cache.Cache;
import me.jessyan.art.integration.cache.LruCache;
import me.jessyan.art.utils.Preconditions;

public class IntelligentCache<V>
implements Cache<String, V> {
    private final Map<String, V> mMap = new HashMap<String, V>();
    private final Cache<String, V> mCache;
    public static final String KEY_KEEP = "Keep=";

    public IntelligentCache(int size) {
        this.mCache = new LruCache<String, V>(size);
    }

    @Override
    public synchronized int size() {
        return this.mMap.size() + this.mCache.size();
    }

    @Override
    public synchronized int getMaxSize() {
        return this.mMap.size() + this.mCache.getMaxSize();
    }

    @Override
    @Nullable
    public synchronized V get(String key) {
        if (key.startsWith(KEY_KEEP)) {
            return this.mMap.get(key);
        }
        return this.mCache.get(key);
    }

    @Override
    @Nullable
    public synchronized V put(String key, V value) {
        if (key.startsWith(KEY_KEEP)) {
            return this.mMap.put(key, value);
        }
        return this.mCache.put(key, value);
    }

    @Override
    @Nullable
    public synchronized V remove(String key) {
        if (key.startsWith(KEY_KEEP)) {
            return this.mMap.remove(key);
        }
        return this.mCache.remove(key);
    }

    @Override
    public synchronized boolean containsKey(String key) {
        if (key.startsWith(KEY_KEEP)) {
            return this.mMap.containsKey(key);
        }
        return this.mCache.containsKey(key);
    }

    @Override
    public synchronized Set<String> keySet() {
        Set<String> set = this.mCache.keySet();
        set.addAll(this.mMap.keySet());
        return set;
    }

    @Override
    public void clear() {
        this.mCache.clear();
        this.mMap.clear();
    }

    @NonNull
    public static String getKeyOfKeep(@NonNull String key) {
        Preconditions.checkNotNull(key, "key == null");
        return KEY_KEEP + key;
    }
}

