/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.integration.cache;

import android.app.ActivityManager;
import android.content.Context;

public interface CacheType {
    public static final int REPOSITORY_CACHE_TYPE_ID = 0;
    public static final int RETROFIT_SERVICE_CACHE_TYPE_ID = 1;
    public static final int CACHE_SERVICE_CACHE_TYPE_ID = 2;
    public static final int EXTRAS_TYPE_ID = 3;
    public static final int ACTIVITY_CACHE_TYPE_ID = 4;
    public static final int FRAGMENT_CACHE_TYPE_ID = 5;
    public static final CacheType REPOSITORY_CACHE = new CacheType(){
        private static final int MAX_SIZE = 150;
        private static final float MAX_SIZE_MULTIPLIER = 0.002f;

        @Override
        public int getCacheTypeId() {
            return 0;
        }

        @Override
        public int calculateCacheSize(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            int targetMemoryCacheSize = (int)((float)activityManager.getMemoryClass() * 0.002f * 1024.0f);
            if (targetMemoryCacheSize >= 150) {
                return 150;
            }
            return targetMemoryCacheSize;
        }
    };
    public static final CacheType RETROFIT_SERVICE_CACHE = new CacheType(){
        private static final int MAX_SIZE = 150;
        private static final float MAX_SIZE_MULTIPLIER = 0.002f;

        @Override
        public int getCacheTypeId() {
            return 1;
        }

        @Override
        public int calculateCacheSize(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            int targetMemoryCacheSize = (int)((float)activityManager.getMemoryClass() * 0.002f * 1024.0f);
            if (targetMemoryCacheSize >= 150) {
                return 150;
            }
            return targetMemoryCacheSize;
        }
    };
    public static final CacheType CACHE_SERVICE_CACHE = new CacheType(){
        private static final int MAX_SIZE = 150;
        private static final float MAX_SIZE_MULTIPLIER = 0.002f;

        @Override
        public int getCacheTypeId() {
            return 2;
        }

        @Override
        public int calculateCacheSize(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            int targetMemoryCacheSize = (int)((float)activityManager.getMemoryClass() * 0.002f * 1024.0f);
            if (targetMemoryCacheSize >= 150) {
                return 150;
            }
            return targetMemoryCacheSize;
        }
    };
    public static final CacheType EXTRAS = new CacheType(){
        private static final int MAX_SIZE = 500;
        private static final float MAX_SIZE_MULTIPLIER = 0.005f;

        @Override
        public int getCacheTypeId() {
            return 3;
        }

        @Override
        public int calculateCacheSize(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            int targetMemoryCacheSize = (int)((float)activityManager.getMemoryClass() * 0.005f * 1024.0f);
            if (targetMemoryCacheSize >= 500) {
                return 500;
            }
            return targetMemoryCacheSize;
        }
    };
    public static final CacheType ACTIVITY_CACHE = new CacheType(){
        private static final int MAX_SIZE = 80;
        private static final float MAX_SIZE_MULTIPLIER = 8.0E-4f;

        @Override
        public int getCacheTypeId() {
            return 4;
        }

        @Override
        public int calculateCacheSize(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            int targetMemoryCacheSize = (int)((float)activityManager.getMemoryClass() * 8.0E-4f * 1024.0f);
            if (targetMemoryCacheSize >= 80) {
                return 80;
            }
            return targetMemoryCacheSize;
        }
    };
    public static final CacheType FRAGMENT_CACHE = new CacheType(){
        private static final int MAX_SIZE = 80;
        private static final float MAX_SIZE_MULTIPLIER = 8.0E-4f;

        @Override
        public int getCacheTypeId() {
            return 5;
        }

        @Override
        public int calculateCacheSize(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            int targetMemoryCacheSize = (int)((float)activityManager.getMemoryClass() * 8.0E-4f * 1024.0f);
            if (targetMemoryCacheSize >= 80) {
                return 80;
            }
            return targetMemoryCacheSize;
        }
    };

    public int getCacheTypeId();

    public int calculateCacheSize(Context var1);
}

