/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.integration;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Message;
import android.os.Process;
import android.support.annotation.Nullable;
import android.support.design.widget.Snackbar;
import android.view.View;
import io.reactivex.Completable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Action;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import me.jessyan.art.base.Platform;
import me.jessyan.art.utils.ArtUtils;
import timber.log.Timber;

public final class AppManager {
    protected final String TAG = this.getClass().getSimpleName();
    public static final String IS_NOT_ADD_ACTIVITY_LIST = "is_not_add_activity_list";
    private static volatile AppManager sAppManager;
    private Application mApplication;
    private List<Activity> mActivityList;
    private Activity mCurrentActivity;
    private HandleListener mHandleListener;

    private AppManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppManager getAppManager() {
        if (sAppManager != null) return sAppManager;
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            if (sAppManager != null) return sAppManager;
            sAppManager = new AppManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sAppManager;
        }
    }

    public AppManager init(Application application) {
        this.mApplication = application;
        return sAppManager;
    }

    @Deprecated
    public void onReceive(Message message) {
        if (this.mHandleListener != null) {
            this.mHandleListener.handleMessage(this, message);
        }
    }

    @Deprecated
    public HandleListener getHandleListener() {
        return this.mHandleListener;
    }

    @Deprecated
    public void setHandleListener(HandleListener handleListener) {
        this.mHandleListener = handleListener;
    }

    @Deprecated
    public static void post(Message msg) {
        AppManager.getAppManager().onReceive(msg);
    }

    public void showSnackbar(final String message, final boolean isLong) {
        if (this.getCurrentActivity() == null && this.getTopActivity() == null) {
            Timber.tag((String)this.TAG).w("mCurrentActivity == null when showSnackbar(String,boolean)", new Object[0]);
            return;
        }
        Completable.fromAction((Action)new Action(){

            public void run() throws Exception {
                if (Platform.DEPENDENCY_SUPPORT_DESIGN) {
                    Activity activity = AppManager.this.getCurrentActivity() == null ? AppManager.this.getTopActivity() : AppManager.this.getCurrentActivity();
                    View view = activity.getWindow().getDecorView().findViewById(0x1020002);
                    Snackbar.make((View)view, (CharSequence)message, (int)(isLong ? 0 : -1)).show();
                } else {
                    ArtUtils.makeText((Context)AppManager.this.mApplication, message);
                }
            }
        }).subscribeOn(AndroidSchedulers.mainThread()).subscribe();
    }

    public void startActivity(Intent intent) {
        if (this.getTopActivity() == null) {
            Timber.tag((String)this.TAG).w("mCurrentActivity == null when startActivity(Intent)", new Object[0]);
            intent.setFlags(0x10000000);
            this.mApplication.startActivity(intent);
            return;
        }
        this.getTopActivity().startActivity(intent);
    }

    public void startActivity(Class activityClass) {
        this.startActivity(new Intent((Context)this.mApplication, activityClass));
    }

    public void release() {
        this.mActivityList.clear();
        this.mHandleListener = null;
        this.mActivityList = null;
        this.mCurrentActivity = null;
        this.mApplication = null;
    }

    public void setCurrentActivity(Activity currentActivity) {
        this.mCurrentActivity = currentActivity;
    }

    @Nullable
    public Activity getCurrentActivity() {
        return this.mCurrentActivity;
    }

    @Nullable
    public Activity getTopActivity() {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when getTopActivity()", new Object[0]);
            return null;
        }
        return this.mActivityList.size() > 0 ? this.mActivityList.get(this.mActivityList.size() - 1) : null;
    }

    public List<Activity> getActivityList() {
        if (this.mActivityList == null) {
            this.mActivityList = new LinkedList<Activity>();
        }
        return this.mActivityList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivity(Activity activity) {
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            List<Activity> activities = this.getActivityList();
            if (!activities.contains(activity)) {
                activities.add(activity);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActivity(Activity activity) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when removeActivity(Activity)", new Object[0]);
            return;
        }
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            if (this.mActivityList.contains(activity)) {
                this.mActivityList.remove(activity);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity removeActivity(int location) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when removeActivity(int)", new Object[0]);
            return null;
        }
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            if (location > 0 && location < this.mActivityList.size()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.mActivityList.remove(location);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killActivity(Class<?> activityClass) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when killActivity(Class)", new Object[0]);
            return;
        }
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            Iterator<Activity> iterator = this.getActivityList().iterator();
            while (iterator.hasNext()) {
                Activity next = iterator.next();
                if (!next.getClass().equals(activityClass)) continue;
                iterator.remove();
                next.finish();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean activityInstanceIsLive(Activity activity) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when activityInstanceIsLive(Activity)", new Object[0]);
            return false;
        }
        return this.mActivityList.contains(activity);
    }

    public boolean activityClassIsLive(Class<?> activityClass) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when activityClassIsLive(Class)", new Object[0]);
            return false;
        }
        for (Activity activity : this.mActivityList) {
            if (!activity.getClass().equals(activityClass)) continue;
            return true;
        }
        return false;
    }

    public Activity findActivity(Class<?> activityClass) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when findActivity(Class)", new Object[0]);
            return null;
        }
        for (Activity activity : this.mActivityList) {
            if (!activity.getClass().equals(activityClass)) continue;
            return activity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll() {
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            Iterator<Activity> iterator = this.getActivityList().iterator();
            while (iterator.hasNext()) {
                Activity next = iterator.next();
                iterator.remove();
                next.finish();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll(Class<?> ... excludeActivityClasses) {
        List<Class<?>> excludeList = Arrays.asList(excludeActivityClasses);
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            Iterator<Activity> iterator = this.getActivityList().iterator();
            while (iterator.hasNext()) {
                Activity next = iterator.next();
                if (excludeList.contains(next.getClass())) continue;
                iterator.remove();
                next.finish();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll(String ... excludeActivityName) {
        List<String> excludeList = Arrays.asList(excludeActivityName);
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            Iterator<Activity> iterator = this.getActivityList().iterator();
            while (iterator.hasNext()) {
                Activity next = iterator.next();
                if (excludeList.contains(next.getClass().getName())) continue;
                iterator.remove();
                next.finish();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void appExit() {
        try {
            this.killAll();
            Process.killProcess((int)Process.myPid());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static interface HandleListener {
        public void handleMessage(AppManager var1, Message var2);
    }
}

