/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.integration;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import dagger.Lazy;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.jessyan.art.base.delegate.ActivityDelegate;
import me.jessyan.art.base.delegate.ActivityDelegateImpl;
import me.jessyan.art.base.delegate.IActivity;
import me.jessyan.art.integration.AppManager;
import me.jessyan.art.integration.ConfigModule;
import me.jessyan.art.integration.cache.Cache;
import me.jessyan.art.integration.cache.IntelligentCache;
import me.jessyan.art.utils.Preconditions;

@Singleton
public class ActivityLifecycle
implements Application.ActivityLifecycleCallbacks {
    @Inject
    AppManager mAppManager;
    @Inject
    Application mApplication;
    @Inject
    Cache<String, Object> mExtras;
    @Inject
    Lazy<FragmentManager.FragmentLifecycleCallbacks> mFragmentLifecycle;
    @Inject
    Lazy<List<FragmentManager.FragmentLifecycleCallbacks>> mFragmentLifecycles;

    @Inject
    public ActivityLifecycle() {
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        boolean isNotAdd = false;
        if (activity.getIntent() != null) {
            isNotAdd = activity.getIntent().getBooleanExtra("is_not_add_activity_list", false);
        }
        if (!isNotAdd) {
            this.mAppManager.addActivity(activity);
        }
        if (activity instanceof IActivity) {
            ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
            if (activityDelegate == null) {
                Cache<String, Object> cache = this.getCacheFromActivity((IActivity)activity);
                activityDelegate = new ActivityDelegateImpl(activity);
                cache.put(IntelligentCache.getKeyOfKeep("ACTIVITY_DELEGATE"), activityDelegate);
            }
            activityDelegate.onCreate(savedInstanceState);
        }
        this.registerFragmentCallbacks(activity);
    }

    public void onActivityStarted(Activity activity) {
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onStart();
        }
    }

    public void onActivityResumed(Activity activity) {
        this.mAppManager.setCurrentActivity(activity);
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onResume();
        }
    }

    public void onActivityPaused(Activity activity) {
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onPause();
        }
    }

    public void onActivityStopped(Activity activity) {
        ActivityDelegate activityDelegate;
        if (this.mAppManager.getCurrentActivity() == activity) {
            this.mAppManager.setCurrentActivity(null);
        }
        if ((activityDelegate = this.fetchActivityDelegate(activity)) != null) {
            activityDelegate.onStop();
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onSaveInstanceState(outState);
        }
    }

    public void onActivityDestroyed(Activity activity) {
        this.mAppManager.removeActivity(activity);
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onDestroy();
            this.getCacheFromActivity((IActivity)activity).clear();
        }
    }

    private void registerFragmentCallbacks(Activity activity) {
        boolean useFragment;
        boolean bl = useFragment = activity instanceof IActivity ? ((IActivity)activity).useFragment() : true;
        if (activity instanceof FragmentActivity && useFragment) {
            ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this.mFragmentLifecycle.get(), true);
            if (this.mExtras.containsKey(IntelligentCache.getKeyOfKeep(ConfigModule.class.getName()))) {
                List modules = (List)this.mExtras.get(IntelligentCache.getKeyOfKeep(ConfigModule.class.getName()));
                for (ConfigModule module : modules) {
                    module.injectFragmentLifecycle((Context)this.mApplication, (List)this.mFragmentLifecycles.get());
                }
                this.mExtras.remove(IntelligentCache.getKeyOfKeep(ConfigModule.class.getName()));
            }
            for (FragmentManager.FragmentLifecycleCallbacks fragmentLifecycle : (List)this.mFragmentLifecycles.get()) {
                ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks(fragmentLifecycle, true);
            }
        }
    }

    private ActivityDelegate fetchActivityDelegate(Activity activity) {
        ActivityDelegate activityDelegate = null;
        if (activity instanceof IActivity) {
            Cache<String, Object> cache = this.getCacheFromActivity((IActivity)activity);
            activityDelegate = (ActivityDelegate)cache.get(IntelligentCache.getKeyOfKeep("ACTIVITY_DELEGATE"));
        }
        return activityDelegate;
    }

    @NonNull
    private Cache<String, Object> getCacheFromActivity(IActivity activity) {
        Cache<String, Object> cache = activity.provideCache();
        Preconditions.checkNotNull(cache, "%s cannot be null on Activity", Cache.class.getName());
        return cache;
    }
}

