/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.http.log;

import android.support.annotation.Nullable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.jessyan.art.http.GlobalHttpHandler;
import me.jessyan.art.http.log.FormatPrinter;
import me.jessyan.art.utils.CharacterHandler;
import me.jessyan.art.utils.UrlEncoderUtils;
import me.jessyan.art.utils.ZipHelper;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import timber.log.Timber;

@Singleton
public class RequestInterceptor
implements Interceptor {
    @Inject
    @Nullable
    GlobalHttpHandler mHandler;
    @Inject
    FormatPrinter mPrinter;
    @Inject
    Level printLevel;

    @Inject
    public RequestInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response originalResponse;
        boolean logRequest;
        Request request = chain.request();
        boolean bl = logRequest = this.printLevel == Level.ALL || this.printLevel != Level.NONE && this.printLevel == Level.REQUEST;
        if (logRequest) {
            if (request.body() != null && RequestInterceptor.isParseable(request.body().contentType())) {
                this.mPrinter.printJsonRequest(request, RequestInterceptor.parseParams(request));
            } else {
                this.mPrinter.printFileRequest(request);
            }
        }
        boolean logResponse = this.printLevel == Level.ALL || this.printLevel != Level.NONE && this.printLevel == Level.RESPONSE;
        long t1 = logResponse ? System.nanoTime() : 0L;
        try {
            originalResponse = chain.proceed(request);
        }
        catch (Exception e) {
            Timber.w((String)("Http Error: " + e), (Object[])new Object[0]);
            throw e;
        }
        long t2 = logResponse ? System.nanoTime() : 0L;
        ResponseBody responseBody = originalResponse.body();
        String bodyString = null;
        if (responseBody != null && RequestInterceptor.isParseable(responseBody.contentType())) {
            bodyString = this.printResult(request, originalResponse, logResponse);
        }
        if (logResponse) {
            List segmentList = request.url().encodedPathSegments();
            String header = originalResponse.headers().toString();
            int code = originalResponse.code();
            boolean isSuccessful = originalResponse.isSuccessful();
            String message = originalResponse.message();
            String url = originalResponse.request().url().toString();
            if (responseBody != null && RequestInterceptor.isParseable(responseBody.contentType())) {
                this.mPrinter.printJsonResponse(TimeUnit.NANOSECONDS.toMillis(t2 - t1), isSuccessful, code, header, responseBody.contentType(), bodyString, segmentList, message, url);
            } else {
                this.mPrinter.printFileResponse(TimeUnit.NANOSECONDS.toMillis(t2 - t1), isSuccessful, code, header, segmentList, message, url);
            }
        }
        if (this.mHandler != null) {
            return this.mHandler.onHttpResultResponse(bodyString, chain, originalResponse);
        }
        return originalResponse;
    }

    @Nullable
    private String printResult(Request request, Response response, boolean logResponse) throws IOException {
        try {
            ResponseBody responseBody = response.newBuilder().build().body();
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            String encoding = response.headers().get("Content-Encoding");
            Buffer clone = buffer.clone();
            return this.parseContent(responseBody, encoding, clone);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "{\"error\": \"" + e.getMessage() + "\"}";
        }
    }

    private String parseContent(ResponseBody responseBody, String encoding, Buffer clone) {
        Charset charset = Charset.forName("UTF-8");
        MediaType contentType = responseBody.contentType();
        if (contentType != null) {
            charset = contentType.charset(charset);
        }
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            return ZipHelper.decompressForGzip(clone.readByteArray(), RequestInterceptor.convertCharset(charset));
        }
        if (encoding != null && encoding.equalsIgnoreCase("zlib")) {
            return ZipHelper.decompressToStringForZlib(clone.readByteArray(), RequestInterceptor.convertCharset(charset));
        }
        return clone.readString(charset);
    }

    public static String parseParams(Request request) throws UnsupportedEncodingException {
        try {
            String json;
            RequestBody body = request.newBuilder().build().body();
            if (body == null) {
                return "";
            }
            Buffer requestbuffer = new Buffer();
            body.writeTo((BufferedSink)requestbuffer);
            Charset charset = Charset.forName("UTF-8");
            MediaType contentType = body.contentType();
            if (contentType != null) {
                charset = contentType.charset(charset);
            }
            if (UrlEncoderUtils.hasUrlEncoded(json = requestbuffer.readString(charset))) {
                json = URLDecoder.decode(json, RequestInterceptor.convertCharset(charset));
            }
            return CharacterHandler.jsonFormat(json);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "{\"error\": \"" + e.getMessage() + "\"}";
        }
    }

    public static boolean isParseable(MediaType mediaType) {
        if (mediaType == null || mediaType.type() == null) {
            return false;
        }
        return RequestInterceptor.isText(mediaType) || RequestInterceptor.isPlain(mediaType) || RequestInterceptor.isJson(mediaType) || RequestInterceptor.isForm(mediaType) || RequestInterceptor.isHtml(mediaType) || RequestInterceptor.isXml(mediaType);
    }

    public static boolean isText(MediaType mediaType) {
        if (mediaType == null || mediaType.type() == null) {
            return false;
        }
        return mediaType.type().equals("text");
    }

    public static boolean isPlain(MediaType mediaType) {
        if (mediaType == null || mediaType.subtype() == null) {
            return false;
        }
        return mediaType.subtype().toLowerCase().contains("plain");
    }

    public static boolean isJson(MediaType mediaType) {
        if (mediaType == null || mediaType.subtype() == null) {
            return false;
        }
        return mediaType.subtype().toLowerCase().contains("json");
    }

    public static boolean isXml(MediaType mediaType) {
        if (mediaType == null || mediaType.subtype() == null) {
            return false;
        }
        return mediaType.subtype().toLowerCase().contains("xml");
    }

    public static boolean isHtml(MediaType mediaType) {
        if (mediaType == null || mediaType.subtype() == null) {
            return false;
        }
        return mediaType.subtype().toLowerCase().contains("html");
    }

    public static boolean isForm(MediaType mediaType) {
        if (mediaType == null || mediaType.subtype() == null) {
            return false;
        }
        return mediaType.subtype().toLowerCase().contains("x-www-form-urlencoded");
    }

    public static String convertCharset(Charset charset) {
        String s = charset.toString();
        int i = s.indexOf("[");
        if (i == -1) {
            return s;
        }
        return s.substring(i + 1, s.length() - 1);
    }

    public static enum Level {
        NONE,
        REQUEST,
        RESPONSE,
        ALL;

    }
}

