/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.http.imageloader.glide;

import android.content.Context;
import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.Registry;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskLruCacheWrapper;
import com.bumptech.glide.load.engine.cache.LruResourceCache;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.engine.cache.MemorySizeCalculator;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.module.AppGlideModule;
import java.io.File;
import java.io.InputStream;
import me.jessyan.art.di.component.AppComponent;
import me.jessyan.art.http.OkHttpUrlLoader;
import me.jessyan.art.http.imageloader.BaseImageLoaderStrategy;
import me.jessyan.art.http.imageloader.glide.GlideAppliesOptions;
import me.jessyan.art.utils.ArtUtils;
import me.jessyan.art.utils.DataHelper;
import okhttp3.Call;

public class GlideConfiguration
extends AppGlideModule {
    public static final int IMAGE_DISK_CACHE_MAX_SIZE = 0x6400000;

    public void applyOptions(Context context, GlideBuilder builder) {
        final AppComponent appComponent = ArtUtils.obtainAppComponentFromContext(context);
        builder.setDiskCache(new DiskCache.Factory(){

            public DiskCache build() {
                return DiskLruCacheWrapper.create((File)DataHelper.makeDirs(new File(appComponent.cacheFile(), "Glide")), (long)0x6400000L);
            }
        });
        MemorySizeCalculator calculator = new MemorySizeCalculator.Builder(context).build();
        int defaultMemoryCacheSize = calculator.getMemoryCacheSize();
        int defaultBitmapPoolSize = calculator.getBitmapPoolSize();
        int customMemoryCacheSize = (int)(1.2 * (double)defaultMemoryCacheSize);
        int customBitmapPoolSize = (int)(1.2 * (double)defaultBitmapPoolSize);
        builder.setMemoryCache((MemoryCache)new LruResourceCache((long)customMemoryCacheSize));
        builder.setBitmapPool((BitmapPool)new LruBitmapPool((long)customBitmapPoolSize));
        BaseImageLoaderStrategy loadImgStrategy = appComponent.imageLoader().getLoadImgStrategy();
        if (loadImgStrategy != null && loadImgStrategy instanceof GlideAppliesOptions) {
            ((GlideAppliesOptions)((Object)loadImgStrategy)).applyGlideOptions(context, builder);
        }
    }

    public void registerComponents(Context context, Glide glide, Registry registry) {
        AppComponent appComponent = ArtUtils.obtainAppComponentFromContext(context);
        registry.replace(GlideUrl.class, InputStream.class, (ModelLoaderFactory)new OkHttpUrlLoader.Factory((Call.Factory)appComponent.okHttpClient()));
    }

    public boolean isManifestParsingEnabled() {
        return false;
    }
}

