/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.http.imageloader;

import android.content.Context;
import android.support.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.jessyan.art.http.imageloader.BaseImageLoaderStrategy;
import me.jessyan.art.http.imageloader.ImageConfig;
import me.jessyan.art.utils.Preconditions;

@Singleton
public final class ImageLoader {
    @Inject
    @Nullable
    BaseImageLoaderStrategy mStrategy;

    @Inject
    public ImageLoader() {
    }

    public <T extends ImageConfig> void loadImage(Context context, T config) {
        Preconditions.checkNotNull(this.mStrategy, "Please implement BaseImageLoaderStrategy and call GlobalConfigModule.Builder#imageLoaderStrategy(BaseImageLoaderStrategy) in the applyOptions method of ConfigModule");
        this.mStrategy.loadImage(context, config);
    }

    public <T extends ImageConfig> void clear(Context context, T config) {
        Preconditions.checkNotNull(this.mStrategy, "Please implement BaseImageLoaderStrategy and call GlobalConfigModule.Builder#imageLoaderStrategy(BaseImageLoaderStrategy) in the applyOptions method of ConfigModule");
        this.mStrategy.clear(context, config);
    }

    public void setLoadImgStrategy(BaseImageLoaderStrategy strategy) {
        Preconditions.checkNotNull(strategy, "strategy == null");
        this.mStrategy = strategy;
    }

    @Nullable
    public BaseImageLoaderStrategy getLoadImgStrategy() {
        return this.mStrategy;
    }
}

