/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.mvp;

import android.app.Application;
import android.content.Context;
import dagger.Lazy;
import io.rx_cache2.internal.RxCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.jessyan.art.integration.cache.Cache;
import me.jessyan.art.integration.cache.CacheType;
import me.jessyan.art.mvp.IModel;
import me.jessyan.art.mvp.IRepositoryManager;
import me.jessyan.art.utils.Preconditions;
import retrofit2.Retrofit;

@Singleton
public class RepositoryManager
implements IRepositoryManager {
    @Inject
    Lazy<Retrofit> mRetrofit;
    @Inject
    Lazy<RxCache> mRxCache;
    @Inject
    Application mApplication;
    @Inject
    Cache.Factory mCachefactory;
    private Cache<String, IModel> mRepositoryCache;
    private Cache<String, Object> mRetrofitServiceCache;
    private Cache<String, Object> mCacheServiceCache;

    @Inject
    public RepositoryManager() {
    }

    @Override
    public synchronized <T extends IModel> T createRepository(Class<T> repository) {
        if (this.mRepositoryCache == null) {
            this.mRepositoryCache = this.mCachefactory.build(CacheType.REPOSITORY_CACHE);
        }
        Preconditions.checkNotNull(this.mRepositoryCache, "Cannot return null from a Cache.Factory#build(int) method");
        IModel repositoryInstance = this.mRepositoryCache.get(repository.getCanonicalName());
        if (repositoryInstance == null) {
            Constructor<? extends IModel> constructor = RepositoryManager.findConstructorForClass(repository);
            try {
                repositoryInstance = constructor.newInstance(this);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to invoke " + constructor, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to invoke " + constructor, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Create repository error", e);
            }
            this.mRepositoryCache.put(repository.getCanonicalName(), repositoryInstance);
        }
        return (T)repositoryInstance;
    }

    @Override
    public synchronized <T> T createRetrofitService(Class<T> service) {
        if (this.mRetrofitServiceCache == null) {
            this.mRetrofitServiceCache = this.mCachefactory.build(CacheType.RETROFIT_SERVICE_CACHE);
        }
        Preconditions.checkNotNull(this.mRetrofitServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Object retrofitService = this.mRetrofitServiceCache.get(service.getCanonicalName());
        if (retrofitService == null) {
            retrofitService = ((Retrofit)this.mRetrofit.get()).create(service);
            this.mRetrofitServiceCache.put(service.getCanonicalName(), retrofitService);
        }
        return (T)retrofitService;
    }

    @Override
    public synchronized <T> T createCacheService(Class<T> cache) {
        if (this.mCacheServiceCache == null) {
            this.mCacheServiceCache = this.mCachefactory.build(CacheType.CACHE_SERVICE_CACHE);
        }
        Preconditions.checkNotNull(this.mCacheServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Object cacheService = this.mCacheServiceCache.get(cache.getCanonicalName());
        if (cacheService == null) {
            cacheService = ((RxCache)this.mRxCache.get()).using(cache);
            this.mCacheServiceCache.put(cache.getCanonicalName(), cacheService);
        }
        return (T)cacheService;
    }

    @Override
    public void clearAllCache() {
        ((RxCache)this.mRxCache.get()).evictAll();
    }

    @Override
    public Context getContext() {
        return this.mApplication;
    }

    private static Constructor<? extends IModel> findConstructorForClass(Class<?> cls) {
        Constructor<?> bindingCtor;
        String clsName = cls.getName();
        try {
            bindingCtor = cls.getConstructor(IRepositoryManager.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find constructor for " + clsName, e);
        }
        return bindingCtor;
    }
}

