/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.http.imageloader.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.art.http.imageloader.BaseImageLoaderStrategy;
import me.jessyan.art.http.imageloader.glide.BlurTransformation;
import me.jessyan.art.http.imageloader.glide.GlideAppliesOptions;
import me.jessyan.art.http.imageloader.glide.GlideArt;
import me.jessyan.art.http.imageloader.glide.GlideRequests;
import me.jessyan.art.http.imageloader.glide.ImageConfigImpl;
import me.jessyan.art.utils.Preconditions;
import timber.log.Timber;

public class GlideImageLoaderStrategy
implements BaseImageLoaderStrategy<ImageConfigImpl>,
GlideAppliesOptions {
    @Override
    public void loadImage(Context ctx, ImageConfigImpl config) {
        Preconditions.checkNotNull(ctx, "Context is required");
        Preconditions.checkNotNull(config, "ImageConfigImpl is required");
        if (TextUtils.isEmpty((CharSequence)config.getUrl())) {
            throw new NullPointerException("Url is required");
        }
        Preconditions.checkNotNull(config.getImageView(), "ImageView is required");
        GlideRequests requests = GlideArt.with(ctx);
        RequestBuilder glideRequest = requests.load(config.getUrl());
        switch (config.getCacheStrategy()) {
            case 0: {
                glideRequest.diskCacheStrategy(DiskCacheStrategy.ALL);
                break;
            }
            case 1: {
                glideRequest.diskCacheStrategy(DiskCacheStrategy.NONE);
                break;
            }
            case 2: {
                glideRequest.diskCacheStrategy(DiskCacheStrategy.RESOURCE);
                break;
            }
            case 3: {
                glideRequest.diskCacheStrategy(DiskCacheStrategy.DATA);
                break;
            }
            case 4: {
                glideRequest.diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);
                break;
            }
            default: {
                glideRequest.diskCacheStrategy(DiskCacheStrategy.ALL);
            }
        }
        if (config.isCrossFade()) {
            glideRequest.transition((TransitionOptions)DrawableTransitionOptions.withCrossFade());
        }
        if (config.isCenterCrop()) {
            glideRequest.centerCrop();
        }
        if (config.isCircle()) {
            glideRequest.circleCrop();
        }
        if (config.isImageRadius()) {
            glideRequest.transform((Transformation<Bitmap>)new RoundedCorners(config.getImageRadius()));
        }
        if (config.isBlurImage()) {
            glideRequest.transform((Transformation<Bitmap>)new BlurTransformation(config.getBlurValue()));
        }
        if (config.getTransformation() != null) {
            glideRequest.transform((Transformation<Bitmap>)config.getTransformation());
        }
        if (config.getPlaceholder() != 0) {
            glideRequest.placeholder(config.getPlaceholder());
        }
        if (config.getErrorPic() != 0) {
            glideRequest.error(config.getErrorPic());
        }
        if (config.getFallback() != 0) {
            glideRequest.fallback(config.getFallback());
        }
        glideRequest.into(config.getImageView());
    }

    @Override
    public void clear(final Context ctx, ImageConfigImpl config) {
        Preconditions.checkNotNull(ctx, "Context is required");
        Preconditions.checkNotNull(config, "ImageConfigImpl is required");
        if (config.getImageViews() != null && config.getImageViews().length > 0) {
            for (ImageView imageView : config.getImageViews()) {
                GlideArt.get(ctx).getRequestManagerRetriever().get(ctx).clear((View)imageView);
            }
        }
        if (config.isClearDiskCache()) {
            Observable.just((Object)0).observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<Integer>(){

                public void accept(@NonNull Integer integer) throws Exception {
                    Glide.get((Context)ctx).clearDiskCache();
                }
            });
        }
        if (config.isClearMemory()) {
            Observable.just((Object)0).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Integer>(){

                public void accept(@NonNull Integer integer) throws Exception {
                    Glide.get((Context)ctx).clearMemory();
                }
            });
        }
    }

    @Override
    public void applyGlideOptions(Context context, GlideBuilder builder) {
        Timber.w((String)"applyGlideOptions", (Object[])new Object[0]);
    }
}

