/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;

public class ZipHelper {
    private ZipHelper() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static String decompressToStringForZlib(byte[] bytesToDecompress) {
        return ZipHelper.decompressToStringForZlib(bytesToDecompress, "UTF-8");
    }

    public static String decompressToStringForZlib(byte[] bytesToDecompress, String charsetName) {
        byte[] bytesDecompressed = ZipHelper.decompressForZlib(bytesToDecompress);
        String returnValue = null;
        try {
            returnValue = new String(bytesDecompressed, 0, bytesDecompressed.length, charsetName);
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        return returnValue;
    }

    public static byte[] decompressForZlib(byte[] bytesToDecompress) {
        byte[] returnValues = null;
        Inflater inflater = new Inflater();
        int numberOfBytesToDecompress = bytesToDecompress.length;
        inflater.setInput(bytesToDecompress, 0, numberOfBytesToDecompress);
        int bufferSizeInBytes = numberOfBytesToDecompress;
        int numberOfBytesDecompressedSoFar = 0;
        ArrayList<Byte> bytesDecompressedSoFar = new ArrayList<Byte>();
        try {
            while (!inflater.needsInput()) {
                byte[] bytesDecompressedBuffer = new byte[bufferSizeInBytes];
                int numberOfBytesDecompressedThisTime = inflater.inflate(bytesDecompressedBuffer);
                numberOfBytesDecompressedSoFar += numberOfBytesDecompressedThisTime;
                for (int b = 0; b < numberOfBytesDecompressedThisTime; ++b) {
                    bytesDecompressedSoFar.add(bytesDecompressedBuffer[b]);
                }
            }
            returnValues = new byte[bytesDecompressedSoFar.size()];
            for (int b = 0; b < returnValues.length; ++b) {
                returnValues[b] = (Byte)bytesDecompressedSoFar.get(b);
            }
        }
        catch (DataFormatException dfe) {
            dfe.printStackTrace();
        }
        inflater.end();
        return returnValues;
    }

    public static byte[] compressForZlib(byte[] bytesToCompress) {
        Deflater deflater = new Deflater();
        deflater.setInput(bytesToCompress);
        deflater.finish();
        byte[] bytesCompressed = new byte[Short.MAX_VALUE];
        int numberOfBytesAfterCompression = deflater.deflate(bytesCompressed);
        byte[] returnValues = new byte[numberOfBytesAfterCompression];
        System.arraycopy(bytesCompressed, 0, returnValues, 0, numberOfBytesAfterCompression);
        return returnValues;
    }

    public static byte[] compressForZlib(String stringToCompress) {
        byte[] returnValues = null;
        try {
            returnValues = ZipHelper.compressForZlib(stringToCompress.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        return returnValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressForGzip(String string) {
        block5: {
            byte[] byArray;
            ByteArrayOutputStream os = null;
            GZIPOutputStream gos = null;
            try {
                byte[] compressed;
                os = new ByteArrayOutputStream(string.length());
                gos = new GZIPOutputStream(os);
                gos.write(string.getBytes("UTF-8"));
                byArray = compressed = os.toByteArray();
                ZipHelper.closeQuietly(gos);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                ZipHelper.closeQuietly(gos);
                ZipHelper.closeQuietly(os);
            }
            ZipHelper.closeQuietly(os);
            return byArray;
        }
        return null;
    }

    public static String decompressForGzip(byte[] compressed) {
        return ZipHelper.decompressForGzip(compressed, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompressForGzip(byte[] compressed, String charsetName) {
        block6: {
            String string;
            int BUFFER_SIZE = compressed.length;
            GZIPInputStream gis = null;
            ByteArrayInputStream is = null;
            try {
                int bytesRead;
                is = new ByteArrayInputStream(compressed);
                gis = new GZIPInputStream((InputStream)is, BUFFER_SIZE);
                StringBuilder string2 = new StringBuilder();
                byte[] data = new byte[BUFFER_SIZE];
                while ((bytesRead = gis.read(data)) != -1) {
                    string2.append(new String(data, 0, bytesRead, charsetName));
                }
                string = string2.toString();
                ZipHelper.closeQuietly(gis);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                ZipHelper.closeQuietly(gis);
                ZipHelper.closeQuietly(is);
            }
            ZipHelper.closeQuietly(is);
            return string;
        }
        return null;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

