/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.mvp;

import android.os.Bundle;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import me.jessyan.art.mvp.IView;

public final class Message
implements Parcelable {
    public int what;
    public int arg1;
    public int arg2;
    public String str;
    public String presenter;
    public Object obj;
    public Object[] objs;
    public Messenger replyTo;
    public int sendingUid = -1;
    static final int FLAG_IN_USE = 1;
    static final int FLAG_ASYNCHRONOUS = 2;
    static final int FLAGS_TO_CLEAR_ON_COPY_FROM = 1;
    int flags;
    Bundle data;
    IView target;
    Message next;
    private static final Object sPoolSync = new Object();
    private static Message sPool;
    private static int sPoolSize;
    private static final int MAX_POOL_SIZE = 50;
    private static boolean gCheckRecycle;
    public static final Parcelable.Creator<Message> CREATOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message obtain() {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPool != null) {
                Message m = sPool;
                sPool = m.next;
                m.next = null;
                m.flags = 0;
                --sPoolSize;
                return m;
            }
        }
        return new Message();
    }

    public static Message obtain(Message orig) {
        Message m = Message.obtain();
        m.what = orig.what;
        m.str = orig.str;
        m.presenter = orig.presenter;
        m.arg1 = orig.arg1;
        m.arg2 = orig.arg2;
        m.obj = orig.obj;
        m.objs = orig.objs;
        m.replyTo = orig.replyTo;
        m.sendingUid = orig.sendingUid;
        if (orig.data != null) {
            m.data = new Bundle(orig.data);
        }
        m.target = orig.target;
        return m;
    }

    public static Message obtain(IView v) {
        Message m = Message.obtain();
        m.target = v;
        return m;
    }

    public static Message obtain(IView v, Object obj) {
        Message m = Message.obtain();
        m.target = v;
        m.obj = obj;
        return m;
    }

    public static Message obtain(IView v, Object[] objs) {
        Message m = Message.obtain();
        m.target = v;
        m.objs = objs;
        return m;
    }

    public static Message obtain(IView v, Class presenter) {
        Message m = Message.obtain();
        m.target = v;
        m.presenter = presenter.getSimpleName();
        return m;
    }

    public static Message obtain(IView v, Object obj, Class presenter) {
        Message m = Message.obtain();
        m.target = v;
        m.obj = obj;
        m.presenter = presenter.getSimpleName();
        return m;
    }

    public static Message obtain(IView v, Object[] objs, Class presenter) {
        Message m = Message.obtain();
        m.target = v;
        m.objs = objs;
        m.presenter = presenter.getSimpleName();
        return m;
    }

    public static Message obtain(IView v, int what) {
        Message m = Message.obtain();
        m.target = v;
        m.what = what;
        return m;
    }

    public static Message obtain(IView v, int what, Object obj) {
        Message m = Message.obtain();
        m.target = v;
        m.what = what;
        m.obj = obj;
        return m;
    }

    public static Message obtain(IView v, int what, int arg1, int arg2) {
        Message m = Message.obtain();
        m.target = v;
        m.what = what;
        m.arg1 = arg1;
        m.arg2 = arg2;
        return m;
    }

    public static Message obtain(IView v, int what, int arg1, int arg2, Object obj) {
        Message m = Message.obtain();
        m.target = v;
        m.what = what;
        m.arg1 = arg1;
        m.arg2 = arg2;
        m.obj = obj;
        return m;
    }

    public boolean isFromThisPresenter(Class presenter) {
        return this.presenter.equals(presenter.getSimpleName());
    }

    public static void updateCheckRecycle(int targetSdkVersion) {
        if (targetSdkVersion < 21) {
            gCheckRecycle = false;
        }
    }

    public void recycle() {
        if (this.isInUse()) {
            if (gCheckRecycle) {
                throw new IllegalStateException("This message cannot be recycled because it is still in use.");
            }
            return;
        }
        this.recycleUnchecked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycleUnchecked() {
        this.flags = 1;
        this.what = 0;
        this.arg1 = 0;
        this.arg2 = 0;
        this.obj = null;
        this.objs = null;
        this.str = null;
        this.presenter = null;
        this.replyTo = null;
        this.sendingUid = -1;
        this.target = null;
        this.data = null;
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 50) {
                this.next = sPool;
                sPool = this;
                ++sPoolSize;
            }
        }
    }

    public void copyFrom(Message o) {
        this.flags = o.flags & 0xFFFFFFFE;
        this.what = o.what;
        this.str = o.str;
        this.presenter = o.presenter;
        this.arg1 = o.arg1;
        this.arg2 = o.arg2;
        this.obj = o.obj;
        this.objs = o.objs;
        this.replyTo = o.replyTo;
        this.sendingUid = o.sendingUid;
        this.data = o.data != null ? (Bundle)o.data.clone() : null;
    }

    public void setTarget(IView target) {
        this.target = target;
    }

    public IView getTarget() {
        return this.target;
    }

    public Bundle getData() {
        if (this.data == null) {
            this.data = new Bundle();
        }
        return this.data;
    }

    public Bundle peekData() {
        return this.data;
    }

    public void setData(Bundle data) {
        this.data = data;
    }

    @Deprecated
    public void HandleMessageToTarget() {
        if (this.target == null) {
            throw new IllegalArgumentException("target is null");
        }
        this.target.handleMessage(this);
        this.recycleUnchecked();
    }

    public void handleMessageToTarget() {
        if (this.target == null) {
            throw new IllegalArgumentException("target is null");
        }
        this.target.handleMessage(this);
        this.recycleUnchecked();
    }

    @Deprecated
    public void HandleMessageToTargetUnrecycle() {
        if (this.target == null) {
            throw new IllegalArgumentException("target is null");
        }
        this.target.handleMessage(this);
    }

    public void handleMessageToTargetUnrecycle() {
        if (this.target == null) {
            throw new IllegalArgumentException("target is null");
        }
        this.target.handleMessage(this);
    }

    public boolean isAsynchronous() {
        return (this.flags & 2) != 0;
    }

    public void setAsynchronous(boolean async) {
        this.flags = async ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    boolean isInUse() {
        return (this.flags & 1) == 1;
    }

    void markInUse() {
        this.flags |= 1;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        if (this.target != null) {
            b.append(" what=");
            b.append(this.what);
            if (!TextUtils.isEmpty((CharSequence)this.presenter)) {
                b.append(" presenter=");
                b.append(this.presenter);
            }
            if (!TextUtils.isEmpty((CharSequence)this.str)) {
                b.append(" str=");
                b.append(this.str);
            }
            if (this.arg1 != 0) {
                b.append(" arg1=");
                b.append(this.arg1);
            }
            if (this.arg2 != 0) {
                b.append(" arg2=");
                b.append(this.arg2);
            }
            if (this.obj != null) {
                b.append(" obj=");
                b.append(this.obj);
            }
            b.append(" target=");
            b.append(this.target.getClass().getName());
        } else {
            b.append(" barrier=");
            b.append(this.arg1);
        }
        b.append(" }");
        return b.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Parcelable[] p;
        dest.writeInt(this.what);
        dest.writeInt(this.arg1);
        dest.writeInt(this.arg2);
        dest.writeString(this.str);
        dest.writeString(this.presenter);
        if (this.obj != null) {
            try {
                p = (Parcelable[])this.obj;
                dest.writeInt(1);
                dest.writeParcelable((Parcelable)p, flags);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Can't marshal non-Parcelable objects across processes.");
            }
        } else {
            dest.writeInt(0);
        }
        if (this.objs != null) {
            try {
                p = (Parcelable[])this.objs;
                dest.writeInt(1);
                dest.writeParcelableArray(p, flags);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Can't marshal non-Parcelable objects across processes.");
            }
        } else {
            dest.writeInt(0);
        }
        dest.writeBundle(this.data);
        Messenger.writeMessengerOrNullToParcel((Messenger)this.replyTo, (Parcel)dest);
        dest.writeInt(this.sendingUid);
    }

    private void readFromParcel(Parcel source) {
        this.what = source.readInt();
        this.arg1 = source.readInt();
        this.arg2 = source.readInt();
        this.str = source.readString();
        this.presenter = source.readString();
        if (source.readInt() != 0) {
            this.obj = source.readParcelable(this.getClass().getClassLoader());
        }
        if (source.readInt() != 0) {
            this.objs = source.readParcelableArray(this.getClass().getClassLoader());
        }
        this.data = source.readBundle();
        this.replyTo = Messenger.readMessengerOrNullFromParcel((Parcel)source);
        this.sendingUid = source.readInt();
    }

    static {
        sPoolSize = 0;
        gCheckRecycle = true;
        CREATOR = new Parcelable.Creator<Message>(){

            public Message createFromParcel(Parcel source) {
                Message msg = Message.obtain();
                msg.readFromParcel(source);
                return msg;
            }

            public Message[] newArray(int size) {
                return new Message[size];
            }
        };
    }
}

