/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.mvp;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import me.jessyan.art.mvp.IModel;
import me.jessyan.art.mvp.IPresenter;
import me.jessyan.art.utils.Preconditions;
import org.simple.eventbus.EventBus;

public class BasePresenter<M extends IModel>
implements IPresenter,
LifecycleObserver {
    protected final String TAG = this.getClass().getSimpleName();
    protected CompositeDisposable mCompositeDisposable;
    protected M mModel;

    public BasePresenter() {
        this.onStart();
    }

    public BasePresenter(M model) {
        Preconditions.checkNotNull(model, "%s cannot be null", IModel.class.getName());
        this.mModel = model;
        this.onStart();
    }

    @Override
    public void onStart() {
        if (this.useEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
    }

    @Override
    public void onDestroy() {
        if (this.useEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.unDispose();
        if (this.mModel != null) {
            this.mModel.onDestroy();
        }
        this.mModel = null;
        this.mCompositeDisposable = null;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    void onDestroy(LifecycleOwner owner) {
        owner.getLifecycle().removeObserver((LifecycleObserver)this);
    }

    public boolean useEventBus() {
        return true;
    }

    public void addDispose(Disposable disposable) {
        if (this.mCompositeDisposable == null) {
            this.mCompositeDisposable = new CompositeDisposable();
        }
        this.mCompositeDisposable.add(disposable);
    }

    public void unDispose() {
        if (this.mCompositeDisposable != null) {
            this.mCompositeDisposable.clear();
        }
    }
}

