/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.http;

import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import java.io.InputStream;
import me.jessyan.art.http.OkHttpStreamFetcher;
import okhttp3.Call;
import okhttp3.OkHttpClient;

public class OkHttpUrlLoader
implements ModelLoader<GlideUrl, InputStream> {
    private final Call.Factory client;

    public OkHttpUrlLoader(Call.Factory client) {
        this.client = client;
    }

    public boolean handles(GlideUrl url) {
        return true;
    }

    public ModelLoader.LoadData<InputStream> buildLoadData(GlideUrl model, int width, int height, Options options) {
        return new ModelLoader.LoadData((Key)model, (DataFetcher)new OkHttpStreamFetcher(this.client, model));
    }

    public static class Factory
    implements ModelLoaderFactory<GlideUrl, InputStream> {
        private static volatile Call.Factory internalClient;
        private Call.Factory client;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Call.Factory getInternalClient() {
            if (internalClient != null) return internalClient;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (internalClient != null) return internalClient;
                internalClient = new OkHttpClient();
                // ** MonitorExit[var0] (shouldn't be in output)
                return internalClient;
            }
        }

        public Factory() {
            this(Factory.getInternalClient());
        }

        public Factory(Call.Factory client) {
            this.client = client;
        }

        public ModelLoader<GlideUrl, InputStream> build(MultiModelLoaderFactory multiFactory) {
            return new OkHttpUrlLoader(this.client);
        }

        public void teardown() {
        }
    }
}

