/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.base;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import me.jessyan.art.base.delegate.IFragment;
import me.jessyan.art.integration.cache.Cache;
import me.jessyan.art.integration.cache.CacheType;
import me.jessyan.art.mvp.IPresenter;
import me.jessyan.art.utils.ArtUtils;

public abstract class BaseFragment<P extends IPresenter>
extends Fragment
implements IFragment<P> {
    protected final String TAG = this.getClass().getSimpleName();
    private Cache<String, Object> mCache;
    protected P mPresenter;

    @Override
    @NonNull
    public synchronized Cache<String, Object> provideCache() {
        if (this.mCache == null) {
            this.mCache = ArtUtils.obtainAppComponentFromContext((Context)this.getActivity()).cacheFactory().build(CacheType.FRAGMENT_CACHE);
        }
        return this.mCache;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.initView(inflater, container, savedInstanceState);
    }

    @Override
    public void setPresenter(P presenter) {
        this.mPresenter = presenter;
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (this.mPresenter == null) {
            this.mPresenter = this.obtainPresenter();
        }
    }

    @Override
    public boolean useEventBus() {
        return true;
    }
}

