/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.base;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.AttributeSet;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import me.jessyan.art.base.delegate.IActivity;
import me.jessyan.art.integration.cache.Cache;
import me.jessyan.art.integration.cache.CacheType;
import me.jessyan.art.mvp.IPresenter;
import me.jessyan.art.utils.ArtUtils;
import me.jessyan.art.utils.ThirdViewUtil;

public abstract class BaseActivity<P extends IPresenter>
extends AppCompatActivity
implements IActivity<P> {
    protected final String TAG = this.getClass().getSimpleName();
    private Cache<String, Object> mCache;
    private Unbinder mUnbinder;
    protected P mPresenter;

    @Override
    @NonNull
    public synchronized Cache<String, Object> provideCache() {
        if (this.mCache == null) {
            this.mCache = ArtUtils.obtainAppComponentFromContext((Context)this).cacheFactory().build(CacheType.ACTIVITY_CACHE);
        }
        return this.mCache;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        View view = ThirdViewUtil.convertAutoView(name, context, attrs);
        return view == null ? super.onCreateView(name, context, attrs) : view;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            int layoutResID = this.initView(savedInstanceState);
            if (layoutResID != 0) {
                this.setContentView(layoutResID);
                this.mUnbinder = ButterKnife.bind((Activity)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initData(savedInstanceState);
    }

    @Override
    public void setPresenter(P presenter) {
        this.mPresenter = presenter;
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (this.mPresenter == null) {
            this.mPresenter = this.obtainPresenter();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mUnbinder != null && this.mUnbinder != Unbinder.EMPTY) {
            this.mUnbinder.unbind();
        }
        this.mPresenter = null;
        this.mUnbinder = null;
    }

    @Override
    public boolean useEventBus() {
        return true;
    }

    @Override
    public boolean useFragment() {
        return true;
    }
}

