/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.mvp;

import android.app.Application;
import android.content.Context;
import dagger.Lazy;
import io.rx_cache2.internal.RxCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.jessyan.art.integration.cache.Cache;
import me.jessyan.art.integration.cache.CacheType;
import me.jessyan.art.mvp.IModel;
import me.jessyan.art.mvp.IRepositoryManager;
import me.jessyan.art.utils.Preconditions;
import retrofit2.Retrofit;

@Singleton
public class RepositoryManager
implements IRepositoryManager {
    private Lazy<Retrofit> mRetrofit;
    private Lazy<RxCache> mRxCache;
    private Application mApplication;
    private Cache<String, IModel> mRepositoryCache;
    private Cache<String, Object> mRetrofitServiceCache;
    private Cache<String, Object> mCacheServiceCache;
    private Cache.Factory mCachefactory;

    @Inject
    public RepositoryManager(Lazy<Retrofit> retrofit, Lazy<RxCache> rxCache, Application application, Cache.Factory cachefactory) {
        this.mRetrofit = retrofit;
        this.mRxCache = rxCache;
        this.mApplication = application;
        this.mCachefactory = cachefactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IModel> T createRepository(Class<T> repository) {
        IModel repositoryInstance;
        if (this.mRepositoryCache == null) {
            this.mRepositoryCache = this.mCachefactory.build(CacheType.REPOSITORY_CACHE);
        }
        Preconditions.checkNotNull(this.mRepositoryCache, "Cannot return null from a Cache.Factory#build(int) method");
        Cache<String, IModel> cache = this.mRepositoryCache;
        synchronized (cache) {
            repositoryInstance = this.mRepositoryCache.get(repository.getName());
            if (repositoryInstance == null) {
                Constructor<? extends IModel> constructor = RepositoryManager.findConstructorForClass(repository);
                try {
                    repositoryInstance = constructor.newInstance(this);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Unable to invoke " + constructor, e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Unable to invoke " + constructor, e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Create repository error", e);
                }
                this.mRepositoryCache.put(repository.getName(), repositoryInstance);
            }
        }
        return (T)repositoryInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T createRetrofitService(Class<T> service) {
        Object retrofitService;
        if (this.mRetrofitServiceCache == null) {
            this.mRetrofitServiceCache = this.mCachefactory.build(CacheType.RETROFIT_SERVICE_CACHE);
        }
        Preconditions.checkNotNull(this.mRetrofitServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Cache<String, Object> cache = this.mRetrofitServiceCache;
        synchronized (cache) {
            retrofitService = this.mRetrofitServiceCache.get(service.getName());
            if (retrofitService == null) {
                retrofitService = ((Retrofit)this.mRetrofit.get()).create(service);
                this.mRetrofitServiceCache.put(service.getName(), retrofitService);
            }
        }
        return (T)retrofitService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T createCacheService(Class<T> cache) {
        Object cacheService;
        if (this.mCacheServiceCache == null) {
            this.mCacheServiceCache = this.mCachefactory.build(CacheType.CACHE_SERVICE_CACHE);
        }
        Preconditions.checkNotNull(this.mCacheServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Cache<String, Object> cache2 = this.mCacheServiceCache;
        synchronized (cache2) {
            cacheService = this.mCacheServiceCache.get(cache.getName());
            if (cacheService == null) {
                cacheService = ((RxCache)this.mRxCache.get()).using(cache);
                this.mCacheServiceCache.put(cache.getName(), cacheService);
            }
        }
        return (T)cacheService;
    }

    @Override
    public void clearAllCache() {
        ((RxCache)this.mRxCache.get()).evictAll();
    }

    @Override
    public Context getContext() {
        return this.mApplication;
    }

    private static Constructor<? extends IModel> findConstructorForClass(Class<?> cls) {
        Constructor<?> bindingCtor;
        String clsName = cls.getName();
        try {
            bindingCtor = cls.getConstructor(IRepositoryManager.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find constructor for " + clsName, e);
        }
        return bindingCtor;
    }
}

