/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.base.delegate;

import android.app.Activity;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import me.jessyan.art.base.delegate.ActivityDelegate;
import me.jessyan.art.base.delegate.IActivity;
import me.jessyan.art.mvp.IPresenter;
import org.simple.eventbus.EventBus;

public class ActivityDelegateImpl
implements ActivityDelegate {
    private Activity mActivity;
    private IActivity iActivity;
    private IPresenter iPresenter;
    public static final Parcelable.Creator<ActivityDelegateImpl> CREATOR = new Parcelable.Creator<ActivityDelegateImpl>(){

        public ActivityDelegateImpl createFromParcel(Parcel source) {
            return new ActivityDelegateImpl(source);
        }

        public ActivityDelegateImpl[] newArray(int size) {
            return new ActivityDelegateImpl[size];
        }
    };

    public ActivityDelegateImpl(Activity activity) {
        this.mActivity = activity;
        this.iActivity = (IActivity)activity;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        if (this.iActivity.useEventBus()) {
            EventBus.getDefault().register((Object)this.mActivity);
        }
        this.iPresenter = this.iActivity.obtainPresenter();
        this.iActivity.setPresenter(this.iPresenter);
        if (this.mActivity != null && this.mActivity instanceof LifecycleOwner && this.iPresenter != null && this.iPresenter instanceof LifecycleObserver) {
            ((LifecycleOwner)this.mActivity).getLifecycle().addObserver((LifecycleObserver)this.iPresenter);
        }
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
    }

    @Override
    public void onDestroy() {
        if (this.iActivity != null && this.iActivity.useEventBus()) {
            EventBus.getDefault().unregister((Object)this.mActivity);
        }
        if (this.iPresenter != null) {
            this.iPresenter.onDestroy();
        }
        this.iActivity = null;
        this.mActivity = null;
        this.iPresenter = null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
    }

    protected ActivityDelegateImpl(Parcel in) {
        this.mActivity = (Activity)in.readParcelable(Activity.class.getClassLoader());
        this.iActivity = (IActivity)in.readParcelable(IActivity.class.getClassLoader());
        this.iPresenter = (IPresenter)in.readParcelable(IPresenter.class.getClassLoader());
    }
}

