/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.utils;

import com.tbruyelle.rxpermissions2.RxPermissions;
import io.reactivex.Observer;
import java.util.ArrayList;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import timber.log.Timber;

public class PermissionUtil {
    public static final String TAG = "Permission";

    private PermissionUtil() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static void requestPermission(final RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler, String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            return;
        }
        ArrayList<String> needRequest = new ArrayList<String>();
        for (String permission2 : permissions) {
            if (rxPermissions.isGranted(permission2)) continue;
            needRequest.add(permission2);
        }
        if (needRequest.size() == 0) {
            requestPermission.onRequestPermissionSuccess();
        } else {
            rxPermissions.request(needRequest.toArray(new String[needRequest.size()])).subscribe((Observer)new ErrorHandleSubscriber<Boolean>(errorHandler){

                public void onNext(Boolean granted) {
                    if (granted.booleanValue()) {
                        Timber.tag((String)PermissionUtil.TAG).d("Request permissons success", new Object[0]);
                        requestPermission.onRequestPermissionSuccess();
                    } else {
                        Timber.tag((String)PermissionUtil.TAG).d("Request permissons failure", new Object[0]);
                        requestPermission.onRequestPermissionFailure();
                    }
                }
            });
        }
    }

    public static void launchCamera(RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler) {
        PermissionUtil.requestPermission(requestPermission, rxPermissions, errorHandler, "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA");
    }

    public static void externalStorage(RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler) {
        PermissionUtil.requestPermission(requestPermission, rxPermissions, errorHandler, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static void sendSms(RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler) {
        PermissionUtil.requestPermission(requestPermission, rxPermissions, errorHandler, "android.permission.SEND_SMS");
    }

    public static void callPhone(RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler) {
        PermissionUtil.requestPermission(requestPermission, rxPermissions, errorHandler, "android.permission.CALL_PHONE");
    }

    public static void readPhonestate(RequestPermission requestPermission, RxPermissions rxPermissions, RxErrorHandler errorHandler) {
        PermissionUtil.requestPermission(requestPermission, rxPermissions, errorHandler, "android.permission.READ_PHONE_STATE");
    }

    public static interface RequestPermission {
        public void onRequestPermissionSuccess();

        public void onRequestPermissionFailure();
    }
}

