/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.integration;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.jessyan.art.base.delegate.ActivityDelegate;
import me.jessyan.art.base.delegate.ActivityDelegateImpl;
import me.jessyan.art.base.delegate.IActivity;
import me.jessyan.art.integration.AppManager;
import me.jessyan.art.integration.ConfigModule;
import me.jessyan.art.integration.FragmentLifecycle;

@Singleton
public class ActivityLifecycle
implements Application.ActivityLifecycleCallbacks {
    private AppManager mAppManager;
    private Application mApplication;
    private Map<String, Object> mExtras;
    private FragmentManager.FragmentLifecycleCallbacks mFragmentLifecycle;
    private List<FragmentManager.FragmentLifecycleCallbacks> mFragmentLifecycles;

    @Inject
    public ActivityLifecycle(AppManager appManager, Application application, Map<String, Object> extras) {
        this.mAppManager = appManager;
        this.mApplication = application;
        this.mExtras = extras;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        boolean isNotAdd = false;
        if (activity.getIntent() != null) {
            isNotAdd = activity.getIntent().getBooleanExtra("is_not_add_activity_list", false);
        }
        if (!isNotAdd) {
            this.mAppManager.addActivity(activity);
        }
        if (activity instanceof IActivity && activity.getIntent() != null) {
            ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
            if (activityDelegate == null) {
                activityDelegate = new ActivityDelegateImpl(activity);
                activity.getIntent().putExtra("activity_delegate", (Parcelable)activityDelegate);
            }
            activityDelegate.onCreate(savedInstanceState);
        }
        this.registerFragmentCallbacks(activity);
    }

    public void onActivityStarted(Activity activity) {
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onStart();
        }
    }

    public void onActivityResumed(Activity activity) {
        this.mAppManager.setCurrentActivity(activity);
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onResume();
        }
    }

    public void onActivityPaused(Activity activity) {
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onPause();
        }
    }

    public void onActivityStopped(Activity activity) {
        ActivityDelegate activityDelegate;
        if (this.mAppManager.getCurrentActivity() == activity) {
            this.mAppManager.setCurrentActivity(null);
        }
        if ((activityDelegate = this.fetchActivityDelegate(activity)) != null) {
            activityDelegate.onStop();
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onSaveInstanceState(outState);
        }
    }

    public void onActivityDestroyed(Activity activity) {
        this.mAppManager.removeActivity(activity);
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onDestroy();
            activity.getIntent().removeExtra("activity_delegate");
        }
    }

    private void registerFragmentCallbacks(Activity activity) {
        boolean useFragment;
        boolean bl = useFragment = activity instanceof IActivity ? ((IActivity)activity).useFragment() : true;
        if (activity instanceof FragmentActivity && useFragment) {
            if (this.mFragmentLifecycle == null) {
                this.mFragmentLifecycle = new FragmentLifecycle();
            }
            ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks(this.mFragmentLifecycle, true);
            if (this.mFragmentLifecycles == null && this.mExtras.containsKey(ConfigModule.class.getName())) {
                this.mFragmentLifecycles = new ArrayList<FragmentManager.FragmentLifecycleCallbacks>();
                List modules = (List)this.mExtras.get(ConfigModule.class.getName());
                for (ConfigModule module : modules) {
                    module.injectFragmentLifecycle((Context)this.mApplication, this.mFragmentLifecycles);
                }
                this.mExtras.put(ConfigModule.class.getName(), null);
            }
            for (FragmentManager.FragmentLifecycleCallbacks fragmentLifecycle : this.mFragmentLifecycles) {
                ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks(fragmentLifecycle, true);
            }
        }
    }

    private ActivityDelegate fetchActivityDelegate(Activity activity) {
        ActivityDelegate activityDelegate = null;
        if (activity instanceof IActivity && activity.getIntent() != null) {
            activityDelegate = (ActivityDelegate)activity.getIntent().getParcelableExtra("activity_delegate");
        }
        return activityDelegate;
    }
}

