/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.di.module;

import android.app.Application;
import android.content.Context;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import dagger.Module;
import dagger.Provides;
import io.rx_cache2.internal.RxCache;
import io.victoralbertos.jolyglot.GsonSpeaker;
import io.victoralbertos.jolyglot.JolyglotGenerics;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import me.jessyan.art.http.GlobalHttpHandler;
import me.jessyan.art.http.RequestInterceptor;
import me.jessyan.art.utils.DataHelper;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.listener.ResponseErrorListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Module
public class ClientModule {
    private static final int TIME_OUT = 10;

    @Singleton
    @Provides
    Retrofit provideRetrofit(Application application, @Nullable RetrofitConfiguration configuration, Retrofit.Builder builder, OkHttpClient client, HttpUrl httpUrl, Gson gson) {
        builder.baseUrl(httpUrl).client(client);
        if (configuration != null) {
            configuration.configRetrofit((Context)application, builder);
        }
        builder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson));
        return builder.build();
    }

    @Singleton
    @Provides
    OkHttpClient provideClient(Application application, @Nullable OkhttpConfiguration configuration, OkHttpClient.Builder builder, Interceptor intercept, @Nullable List<Interceptor> interceptors, final @Nullable GlobalHttpHandler handler) {
        builder.connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).addNetworkInterceptor(intercept);
        if (handler != null) {
            builder.addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    return chain.proceed(handler.onHttpRequestBefore(chain, chain.request()));
                }
            });
        }
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                builder.addInterceptor(interceptor);
            }
        }
        if (configuration != null) {
            configuration.configOkhttp((Context)application, builder);
        }
        return builder.build();
    }

    @Singleton
    @Provides
    Retrofit.Builder provideRetrofitBuilder() {
        return new Retrofit.Builder();
    }

    @Singleton
    @Provides
    OkHttpClient.Builder provideClientBuilder() {
        return new OkHttpClient.Builder();
    }

    @Singleton
    @Provides
    Interceptor provideInterceptor(RequestInterceptor intercept) {
        return intercept;
    }

    @Singleton
    @Provides
    RxCache provideRxCache(Application application, @Nullable RxCacheConfiguration configuration, @Named(value="RxCacheDirectory") File cacheDirectory) {
        RxCache.Builder builder = new RxCache.Builder();
        if (configuration != null) {
            configuration.configRxCache((Context)application, builder);
        }
        return builder.persistence(cacheDirectory, (JolyglotGenerics)new GsonSpeaker());
    }

    @Singleton
    @Provides
    @Named(value="RxCacheDirectory")
    File provideRxCacheDirectory(File cacheDir) {
        File cacheDirectory = new File(cacheDir, "RxCache");
        return DataHelper.makeDirs(cacheDirectory);
    }

    @Singleton
    @Provides
    RxErrorHandler proRxErrorHandler(Application application, ResponseErrorListener listener) {
        return RxErrorHandler.builder().with((Context)application).responseErrorListener(listener).build();
    }

    public static interface RxCacheConfiguration {
        public void configRxCache(Context var1, RxCache.Builder var2);
    }

    public static interface OkhttpConfiguration {
        public void configOkhttp(Context var1, OkHttpClient.Builder var2);
    }

    public static interface RetrofitConfiguration {
        public void configRetrofit(Context var1, Retrofit.Builder var2);
    }
}

