/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.integration;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Message;
import android.support.design.widget.Snackbar;
import android.view.View;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.simple.eventbus.EventBus;
import org.simple.eventbus.Subscriber;
import org.simple.eventbus.ThreadMode;
import timber.log.Timber;

@Singleton
public final class AppManager {
    protected final String TAG = this.getClass().getSimpleName();
    public static final String APPMANAGER_MESSAGE = "appmanager_message";
    public static final String IS_NOT_ADD_ACTIVITY_LIST = "is_not_add_activity_list";
    public static final int START_ACTIVITY = 0;
    public static final int SHOW_SNACKBAR = 1;
    public static final int KILL_ALL = 2;
    public static final int APP_EXIT = 3;
    private Application mApplication;
    public List<Activity> mActivityList;
    private Activity mCurrentActivity;

    @Inject
    public AppManager(Application application) {
        this.mApplication = application;
        EventBus.getDefault().register((Object)this);
    }

    @Subscriber(tag="appmanager_message", mode=ThreadMode.MAIN)
    public void onReceive(Message message) {
        switch (message.what) {
            case 0: {
                if (message.obj == null) break;
                this.dispatchStart(message);
                break;
            }
            case 1: {
                if (message.obj == null) break;
                this.showSnackbar((String)message.obj, message.arg1 != 0);
                break;
            }
            case 2: {
                this.killAll();
                break;
            }
            case 3: {
                this.appExit();
                break;
            }
            default: {
                Timber.tag((String)this.TAG).w("The message.what not match", new Object[0]);
            }
        }
    }

    private void dispatchStart(Message message) {
        if (message.obj instanceof Intent) {
            this.startActivity((Intent)message.obj);
        } else if (message.obj instanceof Class) {
            this.startActivity((Class)message.obj);
        }
    }

    public void showSnackbar(String message, boolean isLong) {
        if (this.getCurrentActivity() == null) {
            Timber.tag((String)this.TAG).w("mCurrentActivity == null when showSnackbar(String,boolean)", new Object[0]);
            return;
        }
        View view = this.getCurrentActivity().getWindow().getDecorView().findViewById(0x1020002);
        Snackbar.make((View)view, (CharSequence)message, (int)(isLong ? 0 : -1)).show();
    }

    public void startActivity(Intent intent) {
        if (this.getCurrentActivity() == null) {
            Timber.tag((String)this.TAG).w("mCurrentActivity == null when startActivity(Intent)", new Object[0]);
            intent.setFlags(0x10000000);
            this.mApplication.startActivity(intent);
            return;
        }
        this.getCurrentActivity().startActivity(intent);
    }

    public void startActivity(Class activityClass) {
        this.startActivity(new Intent((Context)this.mApplication, activityClass));
    }

    public void release() {
        EventBus.getDefault().unregister((Object)this);
        this.mActivityList.clear();
        this.mActivityList = null;
        this.mCurrentActivity = null;
        this.mApplication = null;
    }

    public void setCurrentActivity(Activity currentActivity) {
        this.mCurrentActivity = currentActivity;
    }

    public Activity getCurrentActivity() {
        return this.mCurrentActivity != null ? this.mCurrentActivity : (this.mActivityList != null && this.mActivityList.size() > 0 ? this.mActivityList.get(this.mActivityList.size() - 1) : null);
    }

    public List<Activity> getActivityList() {
        if (this.mActivityList == null) {
            this.mActivityList = new LinkedList<Activity>();
        }
        return this.mActivityList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivity(Activity activity) {
        if (this.mActivityList == null) {
            this.mActivityList = new LinkedList<Activity>();
        }
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            if (!this.mActivityList.contains(activity)) {
                this.mActivityList.add(activity);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActivity(Activity activity) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when removeActivity(Activity)", new Object[0]);
            return;
        }
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            if (this.mActivityList.contains(activity)) {
                this.mActivityList.remove(activity);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity removeActivity(int location) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when removeActivity(int)", new Object[0]);
            return null;
        }
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            if (location > 0 && location < this.mActivityList.size()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.mActivityList.remove(location);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public void killActivity(Class<?> activityClass) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when killActivity", new Object[0]);
            return;
        }
        for (Activity activity : this.mActivityList) {
            if (!activity.getClass().equals(activityClass)) continue;
            activity.finish();
        }
    }

    public boolean activityInstanceIsLive(Activity activity) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when activityInstanceIsLive", new Object[0]);
            return false;
        }
        return this.mActivityList.contains(activity);
    }

    public boolean activityClassIsLive(Class<?> activityClass) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when activityClassIsLive", new Object[0]);
            return false;
        }
        for (Activity activity : this.mActivityList) {
            if (!activity.getClass().equals(activityClass)) continue;
            return true;
        }
        return false;
    }

    public void killAll() {
        Iterator<Activity> iterator = this.getActivityList().iterator();
        while (iterator.hasNext()) {
            Activity next = iterator.next();
            iterator.remove();
            next.finish();
        }
    }

    public void appExit() {
        try {
            this.killAll();
            if (this.mActivityList != null) {
                this.mActivityList = null;
            }
            ActivityManager activityMgr = (ActivityManager)this.mApplication.getSystemService("activity");
            activityMgr.killBackgroundProcesses(this.mApplication.getPackageName());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

