/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.http;

import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.HttpException;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.util.ContentLengthInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpStreamFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "OkHttpFetcher";
    private final Call.Factory client;
    private final GlideUrl url;
    InputStream stream;
    ResponseBody responseBody;
    private volatile Call call;

    public OkHttpStreamFetcher(Call.Factory client, GlideUrl url) {
        this.client = client;
        this.url = url;
    }

    public void loadData(Priority priority, final DataFetcher.DataCallback<? super InputStream> callback) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url.toStringUrl());
        for (Map.Entry headerEntry : this.url.getHeaders().entrySet()) {
            String key = (String)headerEntry.getKey();
            requestBuilder.addHeader(key, (String)headerEntry.getValue());
        }
        Request request = requestBuilder.build();
        this.call = this.client.newCall(request);
        this.call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (Log.isLoggable((String)OkHttpStreamFetcher.TAG, (int)3)) {
                    Log.d((String)OkHttpStreamFetcher.TAG, (String)"OkHttp failed to obtain result", (Throwable)e);
                }
                callback.onLoadFailed((Exception)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                OkHttpStreamFetcher.this.responseBody = response.body();
                if (response.isSuccessful()) {
                    long contentLength = OkHttpStreamFetcher.this.responseBody.contentLength();
                    OkHttpStreamFetcher.this.stream = ContentLengthInputStream.obtain((InputStream)OkHttpStreamFetcher.this.responseBody.byteStream(), (long)contentLength);
                    callback.onDataReady((Object)OkHttpStreamFetcher.this.stream);
                } else {
                    callback.onLoadFailed((Exception)new HttpException(response.message(), response.code()));
                }
            }
        });
    }

    public void cleanup() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.responseBody != null) {
            this.responseBody.close();
        }
    }

    public void cancel() {
        Call local = this.call;
        if (local != null) {
            local.cancel();
        }
    }

    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }
}

