/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.base.delegate;

import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import me.jessyan.art.base.App;
import me.jessyan.art.base.delegate.AppLifecycles;
import me.jessyan.art.di.component.AppComponent;
import me.jessyan.art.di.component.DaggerAppComponent;
import me.jessyan.art.di.module.AppModule;
import me.jessyan.art.di.module.ClientModule;
import me.jessyan.art.di.module.GlobalConfigModule;
import me.jessyan.art.http.imageloader.glide.ImageConfigImpl;
import me.jessyan.art.integration.ActivityLifecycle;
import me.jessyan.art.integration.ConfigModule;
import me.jessyan.art.integration.ManifestParser;

public class AppDelegate
implements App,
AppLifecycles {
    private Application mApplication;
    private AppComponent mAppComponent;
    @Inject
    protected ActivityLifecycle mActivityLifecycle;
    private List<ConfigModule> mModules;
    private List<AppLifecycles> mAppLifecycles = new ArrayList<AppLifecycles>();
    private List<Application.ActivityLifecycleCallbacks> mActivityLifecycles = new ArrayList<Application.ActivityLifecycleCallbacks>();
    private ComponentCallbacks2 mComponentCallback;

    public AppDelegate(Context context) {
        this.mModules = new ManifestParser(context).parse();
        for (ConfigModule module : this.mModules) {
            module.injectAppLifecycle(context, this.mAppLifecycles);
            module.injectActivityLifecycle(context, this.mActivityLifecycles);
        }
    }

    @Override
    public void attachBaseContext(Context base) {
        for (AppLifecycles lifecycle : this.mAppLifecycles) {
            lifecycle.attachBaseContext(base);
        }
    }

    @Override
    public void onCreate(Application application) {
        this.mApplication = application;
        this.mAppComponent = DaggerAppComponent.builder().appModule(new AppModule(this.mApplication)).clientModule(new ClientModule()).globalConfigModule(this.getGlobalConfigModule((Context)this.mApplication, this.mModules)).build();
        this.mAppComponent.inject(this);
        this.mAppComponent.extras().put(ConfigModule.class.getName(), this.mModules);
        this.mModules = null;
        this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycle);
        for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityLifecycles) {
            this.mApplication.registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
        }
        this.mComponentCallback = new AppComponentCallbacks(this.mApplication, this.mAppComponent);
        this.mApplication.registerComponentCallbacks((ComponentCallbacks)this.mComponentCallback);
        for (AppLifecycles appLifecycles : this.mAppLifecycles) {
            appLifecycles.onCreate(this.mApplication);
        }
    }

    @Override
    public void onTerminate(Application application) {
        if (this.mActivityLifecycle != null) {
            this.mApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycle);
        }
        if (this.mComponentCallback != null) {
            this.mApplication.unregisterComponentCallbacks((ComponentCallbacks)this.mComponentCallback);
        }
        if (this.mActivityLifecycles != null && this.mActivityLifecycles.size() > 0) {
            for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityLifecycles) {
                this.mApplication.unregisterActivityLifecycleCallbacks(activityLifecycleCallbacks);
            }
        }
        if (this.mAppLifecycles != null && this.mAppLifecycles.size() > 0) {
            for (AppLifecycles appLifecycles : this.mAppLifecycles) {
                appLifecycles.onTerminate(this.mApplication);
            }
        }
        this.mAppComponent = null;
        this.mActivityLifecycle = null;
        this.mActivityLifecycles = null;
        this.mComponentCallback = null;
        this.mAppLifecycles = null;
        this.mApplication = null;
    }

    private GlobalConfigModule getGlobalConfigModule(Context context, List<ConfigModule> modules) {
        GlobalConfigModule.Builder builder = GlobalConfigModule.builder();
        for (ConfigModule module : modules) {
            module.applyOptions(context, builder);
        }
        return builder.build();
    }

    @Override
    public AppComponent getAppComponent() {
        return this.mAppComponent;
    }

    private static class AppComponentCallbacks
    implements ComponentCallbacks2 {
        private Application mApplication;
        private AppComponent mAppComponent;

        public AppComponentCallbacks(Application application, AppComponent appComponent) {
            this.mApplication = application;
            this.mAppComponent = appComponent;
        }

        public void onTrimMemory(int level) {
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.mAppComponent.imageLoader().clear((Context)this.mApplication, ImageConfigImpl.builder().isClearMemory(true).build());
        }
    }
}

