/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.widget;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;

public class CustomPopupWindow
extends PopupWindow {
    private View mContentView;
    private View mParentView;
    private CustomPopupWindowListener mListener;
    private boolean isOutsideTouch;
    private boolean isFocus;
    private Drawable mBackgroundDrawable;
    private int mAnimationStyle;
    private boolean isWrap;

    private CustomPopupWindow(Builder builder) {
        this.mContentView = builder.contentView;
        this.mParentView = builder.parentView;
        this.mListener = builder.listener;
        this.isOutsideTouch = builder.isOutsideTouch;
        this.isFocus = builder.isFocus;
        this.mBackgroundDrawable = builder.backgroundDrawable;
        this.mAnimationStyle = builder.animationStyle;
        this.isWrap = builder.isWrap;
        this.initLayout();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initLayout() {
        this.mListener.initPopupView(this.mContentView);
        this.setWidth(this.isWrap ? -2 : -1);
        this.setHeight(this.isWrap ? -2 : -1);
        this.setFocusable(this.isFocus);
        this.setOutsideTouchable(this.isOutsideTouch);
        this.setBackgroundDrawable(this.mBackgroundDrawable);
        if (this.mAnimationStyle != -1) {
            this.setAnimationStyle(this.mAnimationStyle);
        }
        this.setContentView(this.mContentView);
    }

    public View getContentView() {
        return this.mContentView;
    }

    public static View inflateView(ContextThemeWrapper context, int layoutId) {
        return LayoutInflater.from((Context)context).inflate(layoutId, null);
    }

    public void show() {
        if (this.mParentView == null) {
            this.showAtLocation(this.mContentView, 17, 0, 0);
        } else {
            this.showAtLocation(this.mParentView, 17, 0, 0);
        }
    }

    public static interface CustomPopupWindowListener {
        public void initPopupView(View var1);
    }

    public static final class Builder {
        private View contentView;
        private View parentView;
        private CustomPopupWindowListener listener;
        private boolean isOutsideTouch = true;
        private boolean isFocus = true;
        private Drawable backgroundDrawable = new ColorDrawable(0);
        private int animationStyle = -1;
        private boolean isWrap;

        private Builder() {
        }

        public Builder contentView(View contentView) {
            this.contentView = contentView;
            return this;
        }

        public Builder parentView(View parentView) {
            this.parentView = parentView;
            return this;
        }

        public Builder isWrap(boolean isWrap) {
            this.isWrap = isWrap;
            return this;
        }

        public Builder customListener(CustomPopupWindowListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder isOutsideTouch(boolean isOutsideTouch) {
            this.isOutsideTouch = isOutsideTouch;
            return this;
        }

        public Builder isFocus(boolean isFocus) {
            this.isFocus = isFocus;
            return this;
        }

        public Builder backgroundDrawable(Drawable backgroundDrawable) {
            this.backgroundDrawable = backgroundDrawable;
            return this;
        }

        public Builder animationStyle(int animationStyle) {
            this.animationStyle = animationStyle;
            return this;
        }

        public CustomPopupWindow build() {
            if (this.contentView == null) {
                throw new IllegalStateException("contentView is required");
            }
            if (this.listener == null) {
                throw new IllegalStateException("CustomPopupWindowListener is required");
            }
            return new CustomPopupWindow(this);
        }
    }
}

