/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.mvp;

import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import me.jessyan.art.mvp.IModel;
import me.jessyan.art.mvp.IPresenter;
import org.simple.eventbus.EventBus;

public class BasePresenter<M extends IModel>
implements IPresenter {
    protected final String TAG = this.getClass().getSimpleName();
    protected CompositeDisposable mCompositeDisposable;
    protected M mModel;

    public BasePresenter() {
        this.onStart();
    }

    public BasePresenter(M model) {
        this.mModel = model;
        this.onStart();
    }

    @Override
    public void onStart() {
        if (this.useEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
    }

    @Override
    public void onDestroy() {
        if (this.useEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.unDispose();
        if (this.mModel != null) {
            this.mModel.onDestory();
        }
        this.mModel = null;
        this.mCompositeDisposable = null;
    }

    protected boolean useEventBus() {
        return true;
    }

    protected void addDispose(Disposable disposable) {
        if (this.mCompositeDisposable == null) {
            this.mCompositeDisposable = new CompositeDisposable();
        }
        this.mCompositeDisposable.add(disposable);
    }

    protected void unDispose() {
        if (this.mCompositeDisposable != null) {
            this.mCompositeDisposable.clear();
        }
    }
}

