/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.base;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.AttributeSet;
import android.view.View;
import com.zhy.autolayout.AutoFrameLayout;
import com.zhy.autolayout.AutoLinearLayout;
import com.zhy.autolayout.AutoRelativeLayout;
import me.jessyan.art.base.delegate.IActivity;
import me.jessyan.art.mvp.IPresenter;

public abstract class BaseActivity<P extends IPresenter>
extends AppCompatActivity
implements IActivity<P> {
    protected final String TAG = this.getClass().getSimpleName();
    protected P mPresenter;

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        AutoFrameLayout view = null;
        if (name.equals("FrameLayout")) {
            view = new AutoFrameLayout(context, attrs);
        }
        if (name.equals("LinearLayout")) {
            view = new AutoLinearLayout(context, attrs);
        }
        if (name.equals("RelativeLayout")) {
            view = new AutoRelativeLayout(context, attrs);
        }
        return view == null ? super.onCreateView(name, context, attrs) : view;
    }

    @Override
    public void setPresenter(P presenter) {
        this.mPresenter = presenter;
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (this.mPresenter == null) {
            this.mPresenter = this.obtainPresenter();
        }
    }

    @Override
    public boolean useEventBus() {
        return true;
    }

    @Override
    public boolean useFragment() {
        return true;
    }
}

