/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.base.delegate;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import me.jessyan.art.base.delegate.FragmentDelegate;
import me.jessyan.art.base.delegate.IFragment;
import me.jessyan.art.mvp.IPresenter;
import org.simple.eventbus.EventBus;
import timber.log.Timber;

public class FragmentDelegateImpl
implements FragmentDelegate {
    private FragmentManager mFragmentManager;
    private Fragment mFragment;
    private IFragment iFragment;
    private Unbinder mUnbinder;
    private IPresenter iPresenter;
    public static final Parcelable.Creator<FragmentDelegateImpl> CREATOR = new Parcelable.Creator<FragmentDelegateImpl>(){

        public FragmentDelegateImpl createFromParcel(Parcel source) {
            return new FragmentDelegateImpl(source);
        }

        public FragmentDelegateImpl[] newArray(int size) {
            return new FragmentDelegateImpl[size];
        }
    };

    public FragmentDelegateImpl(FragmentManager fragmentManager, Fragment fragment) {
        this.mFragmentManager = fragmentManager;
        this.mFragment = fragment;
        this.iFragment = (IFragment)fragment;
    }

    @Override
    public void onAttach(Context context) {
        if (this.iFragment.useEventBus()) {
            EventBus.getDefault().register((Object)this.mFragment);
        }
        this.iPresenter = this.iFragment.obtainPresenter();
        this.iFragment.setPresenter(this.iPresenter);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
    }

    @Override
    public void onCreateView(View view, Bundle savedInstanceState) {
        if (view != null) {
            this.mUnbinder = ButterKnife.bind((Object)this.mFragment, (View)view);
        }
    }

    @Override
    public void onActivityCreate(Bundle savedInstanceState) {
        this.iFragment.initData();
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
    }

    @Override
    public void onDestroyView() {
        if (this.mUnbinder != null) {
            if (this.mUnbinder != Unbinder.EMPTY) {
                try {
                    this.mUnbinder.unbind();
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    Timber.w((String)("onDestroyView: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
    }

    @Override
    public void onDestroy() {
        if (this.iFragment.useEventBus()) {
            EventBus.getDefault().unregister((Object)this.mFragment);
        }
        if (this.iPresenter != null) {
            this.iPresenter.onDestroy();
        }
        this.mUnbinder = null;
        this.mFragmentManager = null;
        this.mFragment = null;
        this.iFragment = null;
        this.iPresenter = null;
    }

    @Override
    public void onDetach() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
    }

    protected FragmentDelegateImpl(Parcel in) {
        this.mFragmentManager = (FragmentManager)in.readParcelable(FragmentManager.class.getClassLoader());
        this.mFragment = (Fragment)in.readParcelable(Fragment.class.getClassLoader());
        this.iFragment = (IFragment)in.readParcelable(IFragment.class.getClassLoader());
        this.mUnbinder = (Unbinder)in.readParcelable(Unbinder.class.getClassLoader());
        this.iPresenter = (IPresenter)in.readParcelable(IPresenter.class.getClassLoader());
    }
}

