/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DataHelper {
    private static SharedPreferences mSharedPreferences;
    public static final String SP_NAME = "config";

    public static void SetStringSF(Context context, String key, String value) {
        if (mSharedPreferences == null) {
            mSharedPreferences = context.getSharedPreferences(SP_NAME, 0);
        }
        mSharedPreferences.edit().putString(key, value).apply();
    }

    public static String getStringSF(Context context, String key) {
        if (mSharedPreferences == null) {
            mSharedPreferences = context.getSharedPreferences(SP_NAME, 0);
        }
        return mSharedPreferences.getString(key, null);
    }

    public static void SetIntergerSF(Context context, String key, int value) {
        if (mSharedPreferences == null) {
            mSharedPreferences = context.getSharedPreferences(SP_NAME, 0);
        }
        mSharedPreferences.edit().putInt(key, value).apply();
    }

    public static int getIntergerSF(Context context, String key) {
        if (mSharedPreferences == null) {
            mSharedPreferences = context.getSharedPreferences(SP_NAME, 0);
        }
        return mSharedPreferences.getInt(key, -1);
    }

    public static void removeSF(Context context, String key) {
        if (mSharedPreferences == null) {
            mSharedPreferences = context.getSharedPreferences(SP_NAME, 0);
        }
        mSharedPreferences.edit().remove(key).apply();
    }

    public static void clearShareprefrence(Context context) {
        if (mSharedPreferences == null) {
            mSharedPreferences = context.getSharedPreferences(SP_NAME, 0);
        }
        mSharedPreferences.edit().clear().apply();
    }

    public static <T> boolean saveDeviceData(Context context, String key, T device) {
        if (mSharedPreferences == null) {
            mSharedPreferences = context.getSharedPreferences(SP_NAME, 0);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(device);
            String oAuth_Base64 = new String(Base64.encode((byte[])baos.toByteArray(), (int)0));
            mSharedPreferences.edit().putString(key, oAuth_Base64).apply();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static <T> T getDeviceData(Context context, String key) {
        if (mSharedPreferences == null) {
            mSharedPreferences = context.getSharedPreferences(SP_NAME, 0);
        }
        Object device = null;
        String productBase64 = mSharedPreferences.getString(key, null);
        if (productBase64 == null) {
            return null;
        }
        byte[] base64 = Base64.decode((byte[])productBase64.getBytes(), (int)0);
        ByteArrayInputStream bais = new ByteArrayInputStream(base64);
        try {
            ObjectInputStream bis = new ObjectInputStream(bais);
            device = bis.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)device;
    }

    public static File getCacheFile(Context context) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            File file = null;
            file = context.getExternalCacheDir();
            if (file == null) {
                file = new File(DataHelper.getCacheFilePath(context));
                DataHelper.makeDirs(file);
            }
            return file;
        }
        return context.getCacheDir();
    }

    public static String getCacheFilePath(Context context) {
        String packageName = context.getPackageName();
        return "/mnt/sdcard/" + packageName;
    }

    public static File makeDirs(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static long getDirSize(File dir) {
        File[] files;
        if (dir == null) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return 0L;
        }
        long dirSize = 0L;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                dirSize += file.length();
                continue;
            }
            if (!file.isDirectory()) continue;
            dirSize += file.length();
            dirSize += DataHelper.getDirSize(file);
        }
        return dirSize;
    }

    public static boolean DeleteDir(File dir) {
        File[] files;
        if (dir == null) {
            return false;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                file.delete();
                continue;
            }
            if (!file.isDirectory()) continue;
            DataHelper.DeleteDir(file);
        }
        return true;
    }

    public static String BytyToString(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int num = 0;
        while ((num = in.read(buf)) != -1) {
            out.write(buf, 0, buf.length);
        }
        String result = out.toString();
        out.close();
        return result;
    }
}

