/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.mvp;

import io.rx_cache2.internal.RxCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.jessyan.art.mvp.IModel;
import me.jessyan.art.mvp.IRepositoryManager;
import retrofit2.Retrofit;

@Singleton
public class RepositoryManager
implements IRepositoryManager {
    private Retrofit mRetrofit;
    private RxCache mRxCache;
    private final Map<String, IModel> mRepositoryCache = new LinkedHashMap<String, IModel>();
    private final Map<String, Object> mRetrofitServiceCache = new LinkedHashMap<String, Object>();
    private final Map<String, Object> mCacheServiceCache = new LinkedHashMap<String, Object>();

    @Inject
    public RepositoryManager(Retrofit retrofit, RxCache rxCache) {
        this.mRetrofit = retrofit;
        this.mRxCache = rxCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IModel> T createRepository(Class<T> repository) {
        IModel repositoryInstance;
        Map<String, IModel> map = this.mRepositoryCache;
        synchronized (map) {
            repositoryInstance = this.mRepositoryCache.get(repository.getName());
            if (repositoryInstance == null) {
                Constructor<? extends IModel> constructor = RepositoryManager.findConstructorForClass(repository);
                try {
                    repositoryInstance = constructor.newInstance(this);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Unable to invoke " + constructor, e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Unable to invoke " + constructor, e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("create repository error", e);
                }
                this.mRepositoryCache.put(repository.getName(), repositoryInstance);
            }
        }
        return (T)repositoryInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T createRetrofitService(Class<T> service) {
        Object retrofitService;
        Map<String, Object> map = this.mRetrofitServiceCache;
        synchronized (map) {
            retrofitService = this.mRetrofitServiceCache.get(service.getName());
            if (retrofitService == null) {
                retrofitService = this.mRetrofit.create(service);
                this.mRetrofitServiceCache.put(service.getName(), retrofitService);
            }
        }
        return (T)retrofitService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T createCacheService(Class<T> cache) {
        Object cacheService;
        Map<String, Object> map = this.mCacheServiceCache;
        synchronized (map) {
            cacheService = this.mCacheServiceCache.get(cache.getName());
            if (cacheService == null) {
                cacheService = this.mRxCache.using(cache);
                this.mCacheServiceCache.put(cache.getName(), cacheService);
            }
        }
        return (T)cacheService;
    }

    private static Constructor<? extends IModel> findConstructorForClass(Class<?> cls) {
        Constructor<?> bindingCtor;
        String clsName = cls.getName();
        try {
            bindingCtor = cls.getConstructor(IRepositoryManager.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find constructor for " + clsName, e);
        }
        return bindingCtor;
    }
}

