/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.mvp;

import me.jessyan.art.mvp.IModel;
import me.jessyan.art.mvp.IPresenter;
import org.simple.eventbus.EventBus;
import rx.Subscription;
import rx.subscriptions.CompositeSubscription;

public class BasePresenter<M extends IModel>
implements IPresenter {
    protected final String TAG = this.getClass().getSimpleName();
    protected CompositeSubscription mCompositeSubscription;
    protected M mModel;

    public BasePresenter() {
        this.onStart();
    }

    public BasePresenter(M model) {
        this.mModel = model;
    }

    @Override
    public void onStart() {
        if (this.useEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
    }

    @Override
    public void onDestroy() {
        if (this.useEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.unSubscribe();
        if (this.mModel != null) {
            this.mModel.onDestory();
        }
        this.mModel = null;
        this.mCompositeSubscription = null;
    }

    protected boolean useEventBus() {
        return true;
    }

    protected void addSubscrebe(Subscription subscription) {
        if (this.mCompositeSubscription == null) {
            this.mCompositeSubscription = new CompositeSubscription();
        }
        this.mCompositeSubscription.add(subscription);
    }

    protected void unSubscribe() {
        if (this.mCompositeSubscription != null) {
            this.mCompositeSubscription.unsubscribe();
        }
    }
}

