/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.integration;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.jessyan.art.base.delegate.ActivityDelegate;
import me.jessyan.art.base.delegate.ActivityDelegateImpl;
import me.jessyan.art.base.delegate.FragmentDelegate;
import me.jessyan.art.base.delegate.FragmentDelegateImpl;
import me.jessyan.art.base.delegate.IActivity;
import me.jessyan.art.base.delegate.IFragment;
import me.jessyan.art.integration.AppManager;
import me.jessyan.art.integration.ConfigModule;
import timber.log.Timber;

@Singleton
public class ActivityLifecycle
implements Application.ActivityLifecycleCallbacks {
    private AppManager mAppManager;
    private Application mApplication;
    private Map<String, Object> mExtras;
    private FragmentLifecycle mFragmentLifecycle;
    private List<FragmentManager.FragmentLifecycleCallbacks> mFragmentLifecycles;

    @Inject
    public ActivityLifecycle(AppManager appManager, Application application, Map<String, Object> extras) {
        this.mAppManager = appManager;
        this.mApplication = application;
        this.mExtras = extras;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        boolean isNotAdd = false;
        if (activity.getIntent() != null) {
            isNotAdd = activity.getIntent().getBooleanExtra("is_add_activity_list", false);
        }
        if (!isNotAdd) {
            this.mAppManager.addActivity(activity);
        }
        if (activity instanceof IActivity && activity.getIntent() != null) {
            ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
            if (activityDelegate == null) {
                activityDelegate = new ActivityDelegateImpl(activity);
                activity.getIntent().putExtra("activity_delegate", (Parcelable)activityDelegate);
            }
            activityDelegate.onCreate(savedInstanceState);
        }
    }

    public void onActivityStarted(Activity activity) {
        boolean useFragment;
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onStart();
        }
        boolean bl = useFragment = activity instanceof IActivity ? ((IActivity)activity).useFragment() : true;
        if (activity instanceof FragmentActivity && useFragment) {
            if (this.mFragmentLifecycle == null) {
                this.mFragmentLifecycle = new FragmentLifecycle();
            }
            ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this.mFragmentLifecycle, true);
            if (this.mFragmentLifecycles == null) {
                this.mFragmentLifecycles = new ArrayList<FragmentManager.FragmentLifecycleCallbacks>();
                List modules = (List)this.mExtras.get(ConfigModule.class.getName());
                for (ConfigModule module : modules) {
                    module.injectFragmentLifecycle((Context)this.mApplication, this.mFragmentLifecycles);
                }
            }
            for (FragmentManager.FragmentLifecycleCallbacks fragmentLifecycle : this.mFragmentLifecycles) {
                ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks(fragmentLifecycle, true);
            }
        }
    }

    public void onActivityResumed(Activity activity) {
        this.mAppManager.setCurrentActivity(activity);
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onResume();
        }
    }

    public void onActivityPaused(Activity activity) {
        ActivityDelegate activityDelegate;
        if (this.mAppManager.getCurrentActivity() == activity) {
            this.mAppManager.setCurrentActivity(null);
        }
        if ((activityDelegate = this.fetchActivityDelegate(activity)) != null) {
            activityDelegate.onPause();
        }
    }

    public void onActivityStopped(Activity activity) {
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onStop();
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onSaveInstanceState(outState);
        }
    }

    public void onActivityDestroyed(Activity activity) {
        ActivityDelegate activityDelegate;
        boolean useFragment;
        this.mAppManager.removeActivity(activity);
        boolean bl = useFragment = activity instanceof IActivity ? ((IActivity)activity).useFragment() : true;
        if (activity instanceof FragmentActivity && useFragment) {
            if (this.mFragmentLifecycle != null) {
                ((FragmentActivity)activity).getSupportFragmentManager().unregisterFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this.mFragmentLifecycle);
            }
            if (this.mFragmentLifecycles != null && this.mFragmentLifecycles.size() > 0) {
                for (FragmentManager.FragmentLifecycleCallbacks fragmentLifecycle : this.mFragmentLifecycles) {
                    ((FragmentActivity)activity).getSupportFragmentManager().unregisterFragmentLifecycleCallbacks(fragmentLifecycle);
                }
            }
        }
        if ((activityDelegate = this.fetchActivityDelegate(activity)) != null) {
            activityDelegate.onDestroy();
            activity.getIntent().removeExtra("activity_delegate");
        }
    }

    private ActivityDelegate fetchActivityDelegate(Activity activity) {
        ActivityDelegate activityDelegate = null;
        if (activity instanceof IActivity && activity.getIntent() != null) {
            activityDelegate = (ActivityDelegate)activity.getIntent().getParcelableExtra("activity_delegate");
        }
        return activityDelegate;
    }

    static class FragmentLifecycle
    extends FragmentManager.FragmentLifecycleCallbacks {
        FragmentLifecycle() {
        }

        public void onFragmentAttached(FragmentManager fm, Fragment f, Context context) {
            super.onFragmentAttached(fm, f, context);
            Timber.w((String)(f.toString() + "onFragmentAttached"), (Object[])new Object[0]);
            if (f instanceof IFragment && f.getArguments() != null) {
                FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
                if (fragmentDelegate == null) {
                    fragmentDelegate = new FragmentDelegateImpl(fm, f);
                    f.getArguments().putParcelable("fragment_delegate", (Parcelable)fragmentDelegate);
                }
                fragmentDelegate.onAttach(context);
            }
        }

        public void onFragmentCreated(FragmentManager fm, Fragment f, Bundle savedInstanceState) {
            super.onFragmentCreated(fm, f, savedInstanceState);
            Timber.w((String)(f.toString() + "onFragmentCreated"), (Object[])new Object[0]);
            FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
            if (fragmentDelegate != null) {
                fragmentDelegate.onCreate(savedInstanceState);
            }
        }

        public void onFragmentViewCreated(FragmentManager fm, Fragment f, View v, Bundle savedInstanceState) {
            super.onFragmentViewCreated(fm, f, v, savedInstanceState);
            Timber.w((String)(f.toString() + "onFragmentViewCreated"), (Object[])new Object[0]);
            FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
            if (fragmentDelegate != null) {
                fragmentDelegate.onCreateView(v, savedInstanceState);
            }
        }

        public void onFragmentActivityCreated(FragmentManager fm, Fragment f, Bundle savedInstanceState) {
            super.onFragmentActivityCreated(fm, f, savedInstanceState);
            Timber.w((String)(f.toString() + "onFragmentActivityCreated"), (Object[])new Object[0]);
            FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
            if (fragmentDelegate != null) {
                fragmentDelegate.onActivityCreate(savedInstanceState);
            }
        }

        public void onFragmentStarted(FragmentManager fm, Fragment f) {
            super.onFragmentStarted(fm, f);
            Timber.w((String)(f.toString() + "onFragmentStarted"), (Object[])new Object[0]);
            FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
            if (fragmentDelegate != null) {
                fragmentDelegate.onStart();
            }
        }

        public void onFragmentResumed(FragmentManager fm, Fragment f) {
            super.onFragmentResumed(fm, f);
            Timber.w((String)(f.toString() + "onFragmentResumed"), (Object[])new Object[0]);
            FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
            if (fragmentDelegate != null) {
                fragmentDelegate.onResume();
            }
        }

        public void onFragmentPaused(FragmentManager fm, Fragment f) {
            super.onFragmentPaused(fm, f);
            Timber.w((String)(f.toString() + "onFragmentPaused"), (Object[])new Object[0]);
            FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
            if (fragmentDelegate != null) {
                fragmentDelegate.onPause();
            }
        }

        public void onFragmentStopped(FragmentManager fm, Fragment f) {
            super.onFragmentStopped(fm, f);
            Timber.w((String)(f.toString() + "onFragmentStopped"), (Object[])new Object[0]);
            FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
            if (fragmentDelegate != null) {
                fragmentDelegate.onStop();
            }
        }

        public void onFragmentViewDestroyed(FragmentManager fm, Fragment f) {
            super.onFragmentViewDestroyed(fm, f);
            Timber.w((String)(f.toString() + "onFragmentViewDestroyed"), (Object[])new Object[0]);
            FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
            if (fragmentDelegate != null) {
                fragmentDelegate.onDestroyView();
            }
        }

        public void onFragmentDestroyed(FragmentManager fm, Fragment f) {
            super.onFragmentDestroyed(fm, f);
            Timber.w((String)(f.toString() + "onFragmentDestroyed"), (Object[])new Object[0]);
            FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
            if (fragmentDelegate != null) {
                fragmentDelegate.onDestroy();
            }
        }

        public void onFragmentDetached(FragmentManager fm, Fragment f) {
            super.onFragmentDetached(fm, f);
            Timber.w((String)(f.toString() + "onFragmentDetached"), (Object[])new Object[0]);
            FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
            if (fragmentDelegate != null) {
                fragmentDelegate.onDetach();
                f.getArguments().clear();
            }
        }

        private FragmentDelegate fetchFragmentDelegate(Fragment fragment) {
            if (fragment instanceof IFragment) {
                return fragment.getArguments() == null ? null : (FragmentDelegate)fragment.getArguments().getParcelable("fragment_delegate");
            }
            return null;
        }
    }
}

