/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.widget.imageloader.glide;

import android.content.Context;
import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskLruCacheWrapper;
import com.bumptech.glide.load.engine.cache.LruResourceCache;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.engine.cache.MemorySizeCalculator;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.module.GlideModule;
import java.io.File;
import java.io.InputStream;
import me.jessyan.art.base.App;
import me.jessyan.art.di.component.AppComponent;
import me.jessyan.art.http.OkHttpUrlLoader;
import me.jessyan.art.utils.DataHelper;
import okhttp3.Call;

public class GlideConfiguration
implements GlideModule {
    public static final int IMAGE_DISK_CACHE_MAX_SIZE = 0x6400000;

    public void applyOptions(final Context context, GlideBuilder builder) {
        builder.setDiskCache(new DiskCache.Factory(){

            public DiskCache build() {
                AppComponent appComponent = ((App)context.getApplicationContext()).getAppComponent();
                return DiskLruCacheWrapper.get((File)DataHelper.makeDirs(new File(appComponent.cacheFile(), "Glide")), (int)0x6400000);
            }
        });
        MemorySizeCalculator calculator = new MemorySizeCalculator(context);
        int defaultMemoryCacheSize = calculator.getMemoryCacheSize();
        int defaultBitmapPoolSize = calculator.getBitmapPoolSize();
        int customMemoryCacheSize = (int)(1.2 * (double)defaultMemoryCacheSize);
        int customBitmapPoolSize = (int)(1.2 * (double)defaultBitmapPoolSize);
        builder.setMemoryCache((MemoryCache)new LruResourceCache(customMemoryCacheSize));
        builder.setBitmapPool((BitmapPool)new LruBitmapPool(customBitmapPoolSize));
    }

    public void registerComponents(Context context, Glide glide) {
        AppComponent appComponent = ((App)context.getApplicationContext()).getAppComponent();
        glide.register(GlideUrl.class, InputStream.class, (ModelLoaderFactory)new OkHttpUrlLoader.Factory((Call.Factory)appComponent.okHttpClient()));
    }
}

