/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.mvp;

import me.jessyan.art.mvp.IPresenter;
import org.simple.eventbus.EventBus;
import rx.Subscription;
import rx.subscriptions.CompositeSubscription;

public class BasePresenter
implements IPresenter {
    protected final String TAG = this.getClass().getSimpleName();
    protected CompositeSubscription mCompositeSubscription;

    public BasePresenter() {
        this.onStart();
    }

    @Override
    public void onStart() {
        if (this.useEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
    }

    @Override
    public void onDestroy() {
        if (this.useEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.unSubscribe();
        this.mCompositeSubscription = null;
    }

    protected boolean useEventBus() {
        return true;
    }

    protected void addSubscrebe(Subscription subscription) {
        if (this.mCompositeSubscription == null) {
            this.mCompositeSubscription = new CompositeSubscription();
        }
        this.mCompositeSubscription.add(subscription);
    }

    protected void unSubscribe() {
        if (this.mCompositeSubscription != null) {
            this.mCompositeSubscription.unsubscribe();
        }
    }
}

