/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.di.module;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import dagger.Module;
import dagger.Provides;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import me.jessyan.art.http.GlobalHttpHandler;
import me.jessyan.art.utils.DataHelper;
import me.jessyan.art.utils.Preconditions;
import me.jessyan.rxerrorhandler.handler.listener.ResponseErroListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;

@Module
public class GlobalConfigModule {
    private HttpUrl mApiUrl;
    private GlobalHttpHandler mHandler;
    private List<Interceptor> mInterceptors;
    private ResponseErroListener mErroListener;
    private File mCacheFile;

    private GlobalConfigModule(Builder builder) {
        this.mApiUrl = builder.apiUrl;
        this.mHandler = builder.handler;
        this.mInterceptors = builder.interceptors;
        this.mErroListener = builder.responseErroListener;
        this.mCacheFile = builder.cacheFile;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Singleton
    @Provides
    List<Interceptor> provideInterceptors() {
        return this.mInterceptors;
    }

    @Singleton
    @Provides
    HttpUrl provideBaseUrl() {
        return this.mApiUrl;
    }

    @Singleton
    @Provides
    GlobalHttpHandler provideGlobalHttpHandler() {
        return this.mHandler == null ? GlobalHttpHandler.EMPTY : this.mHandler;
    }

    @Singleton
    @Provides
    File provideCacheFile(Application application) {
        return this.mCacheFile == null ? DataHelper.getCacheFile((Context)application) : this.mCacheFile;
    }

    @Singleton
    @Provides
    ResponseErroListener provideResponseErroListener() {
        return this.mErroListener == null ? ResponseErroListener.EMPTY : this.mErroListener;
    }

    public static final class Builder {
        private HttpUrl apiUrl = HttpUrl.parse((String)"https://api.github.com/");
        private GlobalHttpHandler handler;
        private List<Interceptor> interceptors = new ArrayList<Interceptor>();
        private ResponseErroListener responseErroListener;
        private File cacheFile;

        private Builder() {
        }

        public Builder baseurl(String baseurl) {
            if (TextUtils.isEmpty((CharSequence)baseurl)) {
                throw new IllegalArgumentException("baseurl can not be empty");
            }
            this.apiUrl = HttpUrl.parse((String)baseurl);
            return this;
        }

        public Builder globalHttpHandler(GlobalHttpHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder addInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder responseErroListener(ResponseErroListener listener) {
            this.responseErroListener = listener;
            return this;
        }

        public Builder cacheFile(File cacheFile) {
            this.cacheFile = cacheFile;
            return this;
        }

        public GlobalConfigModule build() {
            Preconditions.checkNotNull(this.apiUrl, "baseurl is required");
            return new GlobalConfigModule(this);
        }
    }
}

