/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.di.module;

import android.app.Application;
import android.content.Context;
import dagger.Module;
import dagger.Provides;
import io.rx_cache.internal.RxCache;
import io.victoralbertos.jolyglot.GsonSpeaker;
import io.victoralbertos.jolyglot.JolyglotGenerics;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import me.jessyan.art.di.module.ClientModule$$Lambda$1;
import me.jessyan.art.di.module.ClientModule$$Lambda$4;
import me.jessyan.art.http.GlobalHttpHandler;
import me.jessyan.art.http.RequestInterceptor;
import me.jessyan.art.utils.DataHelper;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.listener.ResponseErroListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Module
public class ClientModule {
    private static final int TIME_OUT = 10;

    @Singleton
    @Provides
    Retrofit provideRetrofit(Retrofit.Builder builder, OkHttpClient client, HttpUrl httpUrl) {
        return builder.baseUrl(httpUrl).client(client).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
    }

    @Singleton
    @Provides
    OkHttpClient provideClient(OkHttpClient.Builder okHttpClient, Interceptor intercept, List<Interceptor> interceptors, GlobalHttpHandler handler) {
        OkHttpClient.Builder builder = okHttpClient.connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).addInterceptor(ClientModule$$Lambda$1.lambdaFactory$(handler)).addNetworkInterceptor(intercept);
        if (interceptors != null && interceptors.size() > 0) {
            OkHttpClient.Builder builder2 = builder;
            builder2.getClass();
            interceptors.forEach(ClientModule$$Lambda$4.lambdaFactory$(builder2));
        }
        return builder.build();
    }

    @Singleton
    @Provides
    Retrofit.Builder provideRetrofitBuilder() {
        return new Retrofit.Builder();
    }

    @Singleton
    @Provides
    OkHttpClient.Builder provideClientBuilder() {
        return new OkHttpClient.Builder();
    }

    @Singleton
    @Provides
    Interceptor provideInterceptor(RequestInterceptor intercept) {
        return intercept;
    }

    @Singleton
    @Provides
    RxCache provideRxCache(@Named(value="RxCacheDirectory") File cacheDirectory) {
        return new RxCache.Builder().persistence(cacheDirectory, (JolyglotGenerics)new GsonSpeaker());
    }

    @Singleton
    @Provides
    @Named(value="RxCacheDirectory")
    File provideRxCacheDirectory(File cacheDir) {
        File cacheDirectory = new File(cacheDir, "RxCache");
        return DataHelper.makeDirs(cacheDirectory);
    }

    @Singleton
    @Provides
    RxErrorHandler proRxErrorHandler(Application application, ResponseErroListener listener) {
        return RxErrorHandler.builder().with((Context)application).responseErroListener(listener).build();
    }

    static /* synthetic */ Response lambda$provideClient$0(GlobalHttpHandler globalHttpHandler, Interceptor.Chain chain) throws IOException {
        return chain.proceed(globalHttpHandler.onHttpRequestBefore(chain, chain.request()));
    }
}

