/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.base.delegate;

import android.app.Application;
import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import me.jessyan.art.di.component.AppComponent;
import me.jessyan.art.di.component.DaggerAppComponent;
import me.jessyan.art.di.module.AppModule;
import me.jessyan.art.di.module.ClientModule;
import me.jessyan.art.di.module.GlobalConfigModule;
import me.jessyan.art.di.module.ImageModule;
import me.jessyan.art.integration.ActivityLifecycle;
import me.jessyan.art.integration.ConfigModule;
import me.jessyan.art.integration.ManifestParser;

public class AppDelegate {
    private Application mApplication;
    private AppComponent mAppComponent;
    @Inject
    protected ActivityLifecycle mActivityLifecycle;
    private final List<ConfigModule> mModules;
    private List<Lifecycle> mLifecycles = new ArrayList<Lifecycle>();

    public AppDelegate(Application application) {
        this.mApplication = application;
        this.mModules = new ManifestParser(this.mApplication).parse();
        for (ConfigModule module : this.mModules) {
            module.injectAppLifecycle((Context)this.mApplication, this.mLifecycles);
        }
    }

    public void onCreate() {
        this.mAppComponent = DaggerAppComponent.builder().appModule(new AppModule(this.mApplication)).clientModule(new ClientModule()).imageModule(new ImageModule()).globalConfigModule(this.getGlobalConfigModule(this.mApplication, this.mModules)).build();
        this.mAppComponent.inject(this);
        this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycle);
        for (Lifecycle lifecycle : this.mLifecycles) {
            lifecycle.onCreate(this.mApplication);
        }
    }

    public void onTerminate() {
        if (this.mActivityLifecycle != null) {
            this.mApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycle);
        }
        this.mAppComponent = null;
        this.mActivityLifecycle = null;
        this.mApplication = null;
        for (Lifecycle lifecycle : this.mLifecycles) {
            lifecycle.onTerminate(this.mApplication);
        }
    }

    private GlobalConfigModule getGlobalConfigModule(Application context, List<ConfigModule> modules) {
        GlobalConfigModule.Builder builder = GlobalConfigModule.builder();
        for (ConfigModule module : modules) {
            module.applyOptions((Context)context, builder);
        }
        return builder.build();
    }

    public AppComponent getAppComponent() {
        return this.mAppComponent;
    }

    public static interface Lifecycle {
        public void onCreate(Application var1);

        public void onTerminate(Application var1);
    }
}

