/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.base;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.List;
import me.jessyan.art.base.BaseHolder;

public abstract class DefaultAdapter<T>
extends RecyclerView.Adapter<BaseHolder<T>> {
    protected List<T> mInfos;
    protected OnRecyclerViewItemClickListener mOnItemClickListener = null;
    private BaseHolder<T> mHolder;

    public DefaultAdapter(List<T> infos) {
        this.mInfos = infos;
    }

    public BaseHolder<T> onCreateViewHolder(ViewGroup parent, final int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutId(viewType), parent, false);
        this.mHolder = this.getHolder(view, viewType);
        this.mHolder.setOnItemClickListener(new BaseHolder.OnViewClickListener(){

            @Override
            public void onViewClick(View view, int position) {
                if (DefaultAdapter.this.mOnItemClickListener != null) {
                    DefaultAdapter.this.mOnItemClickListener.onItemClick(view, viewType, DefaultAdapter.this.mInfos.get(position), position);
                }
            }
        });
        return this.mHolder;
    }

    public void onBindViewHolder(BaseHolder<T> holder, int position) {
        holder.setData(this.mInfos.get(position), position);
    }

    public int getItemCount() {
        return this.mInfos.size();
    }

    public List<T> getInfos() {
        return this.mInfos;
    }

    public T getItem(int position) {
        return this.mInfos == null ? null : (T)this.mInfos.get(position);
    }

    public abstract BaseHolder<T> getHolder(View var1, int var2);

    public abstract int getLayoutId(int var1);

    public static void releaseAllHolder(RecyclerView recyclerView) {
        if (recyclerView == null) {
            return;
        }
        for (int i = recyclerView.getChildCount() - 1; i >= 0; --i) {
            View view = recyclerView.getChildAt(i);
            RecyclerView.ViewHolder viewHolder = recyclerView.getChildViewHolder(view);
            if (viewHolder == null || !(viewHolder instanceof BaseHolder)) continue;
            ((BaseHolder)viewHolder).onRelease();
        }
    }

    public void setOnItemClickListener(OnRecyclerViewItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public static interface OnRecyclerViewItemClickListener<T> {
        public void onItemClick(View var1, int var2, T var3, int var4);
    }
}

