/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.base;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import me.jessyan.art.mvp.IPresenter;
import org.simple.eventbus.EventBus;

public abstract class BaseFragment<P extends IPresenter>
extends Fragment {
    protected View mRootView;
    protected final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    protected P mPresenter;
    private Unbinder mUnbinder;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mPresenter = this.getPresenter();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = this.initView(inflater, container);
        this.mUnbinder = ButterKnife.bind((Object)((Object)this), (View)this.mRootView);
        return this.mRootView;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.useEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
        this.initData();
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (this.mPresenter == null) {
            this.mPresenter = this.getPresenter();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mUnbinder != Unbinder.EMPTY) {
            this.mUnbinder.unbind();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mPresenter != null) {
            this.mPresenter.onDestroy();
        }
        if (this.useEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.mPresenter = null;
        this.mRootView = null;
        this.mUnbinder = null;
    }

    protected boolean useEventBus() {
        return true;
    }

    protected abstract View initView(LayoutInflater var1, ViewGroup var2);

    protected abstract void initData();

    protected abstract P getPresenter();

    public void setData(Object data) {
    }

    public void setData() {
    }
}

