/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.art.base;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.AttributeSet;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import com.zhy.autolayout.AutoFrameLayout;
import com.zhy.autolayout.AutoLinearLayout;
import com.zhy.autolayout.AutoRelativeLayout;
import me.jessyan.art.mvp.IPresenter;
import org.simple.eventbus.EventBus;

public abstract class BaseActivity<P extends IPresenter>
extends AppCompatActivity {
    protected final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private Unbinder mUnbinder;
    protected P mPresenter;
    private static final String LAYOUT_LINEARLAYOUT = "LinearLayout";
    private static final String LAYOUT_FRAMELAYOUT = "FrameLayout";
    private static final String LAYOUT_RELATIVELAYOUT = "RelativeLayout";
    public static final String IS_NOT_ADD_ACTIVITY_LIST = "is_add_activity_list";

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        AutoFrameLayout view = null;
        if (name.equals(LAYOUT_FRAMELAYOUT)) {
            view = new AutoFrameLayout(context, attrs);
        }
        if (name.equals(LAYOUT_LINEARLAYOUT)) {
            view = new AutoLinearLayout(context, attrs);
        }
        if (name.equals(LAYOUT_RELATIVELAYOUT)) {
            view = new AutoRelativeLayout(context, attrs);
        }
        if (view != null) {
            return view;
        }
        return super.onCreateView(name, context, attrs);
    }

    @Nullable
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mPresenter = this.getPresenter();
        if (this.useEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
        this.setContentView(this.initView());
        this.mUnbinder = ButterKnife.bind((Activity)this);
        this.initData();
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (this.mPresenter == null) {
            this.mPresenter = this.getPresenter();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mPresenter != null) {
            this.mPresenter.onDestroy();
        }
        if (this.mUnbinder != Unbinder.EMPTY) {
            this.mUnbinder.unbind();
        }
        if (this.useEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.mPresenter = null;
        this.mUnbinder = null;
    }

    protected boolean useEventBus() {
        return true;
    }

    protected abstract int initView();

    protected abstract void initData();

    protected abstract P getPresenter();
}

