/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.mvp;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import com.jess.arms.integration.EventBusManager;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IPresenter;
import com.jess.arms.mvp.IView;
import com.jess.arms.utils.Preconditions;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;

public class BasePresenter<M extends IModel, V extends IView>
implements IPresenter,
LifecycleObserver {
    protected final String TAG = this.getClass().getSimpleName();
    protected CompositeDisposable mCompositeDisposable;
    protected M mModel;
    protected V mRootView;

    public BasePresenter(M model, V rootView) {
        Preconditions.checkNotNull(model, "%s cannot be null", IModel.class.getName());
        Preconditions.checkNotNull(rootView, "%s cannot be null", IView.class.getName());
        this.mModel = model;
        this.mRootView = rootView;
        this.onStart();
    }

    public BasePresenter(V rootView) {
        Preconditions.checkNotNull(rootView, "%s cannot be null", IView.class.getName());
        this.mRootView = rootView;
        this.onStart();
    }

    public BasePresenter() {
        this.onStart();
    }

    @Override
    public void onStart() {
        if (this.mRootView != null && this.mRootView instanceof LifecycleOwner) {
            ((LifecycleOwner)this.mRootView).getLifecycle().addObserver((LifecycleObserver)this);
            if (this.mModel != null && this.mModel instanceof LifecycleObserver) {
                ((LifecycleOwner)this.mRootView).getLifecycle().addObserver((LifecycleObserver)this.mModel);
            }
        }
        if (this.useEventBus()) {
            EventBusManager.getInstance().register(this);
        }
    }

    @Override
    public void onDestroy() {
        if (this.useEventBus()) {
            EventBusManager.getInstance().unregister(this);
        }
        this.unDispose();
        if (this.mModel != null) {
            this.mModel.onDestroy();
        }
        this.mModel = null;
        this.mRootView = null;
        this.mCompositeDisposable = null;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    void onDestroy(LifecycleOwner owner) {
        owner.getLifecycle().removeObserver((LifecycleObserver)this);
    }

    public boolean useEventBus() {
        return true;
    }

    public void addDispose(Disposable disposable) {
        if (this.mCompositeDisposable == null) {
            this.mCompositeDisposable = new CompositeDisposable();
        }
        this.mCompositeDisposable.add(disposable);
    }

    public void unDispose() {
        if (this.mCompositeDisposable != null) {
            this.mCompositeDisposable.clear();
        }
    }
}

