/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.integration;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.integration.cache.Cache;
import com.jess.arms.integration.cache.CacheType;
import com.jess.arms.utils.Preconditions;
import dagger.Lazy;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.rx_cache2.internal.RxCache;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import javax.inject.Singleton;
import retrofit2.Retrofit;

@Singleton
public class RepositoryManager
implements IRepositoryManager {
    @Inject
    Lazy<Retrofit> mRetrofit;
    @Inject
    Lazy<RxCache> mRxCache;
    @Inject
    Application mApplication;
    @Inject
    Cache.Factory mCachefactory;
    private Cache<String, Object> mRetrofitServiceCache;
    private Cache<String, Object> mCacheServiceCache;

    @Inject
    public RepositoryManager() {
    }

    @Override
    @NonNull
    public synchronized <T> T obtainRetrofitService(@NonNull Class<T> serviceClass) {
        return this.createWrapperService(serviceClass);
    }

    private <T> T createWrapperService(final Class<T> serviceClass) {
        Preconditions.checkNotNull(serviceClass, "serviceClass == null");
        return (T)Proxy.newProxyInstance(serviceClass.getClassLoader(), new Class[]{serviceClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
                if (method.getReturnType() == Observable.class) {
                    return Observable.defer(() -> {
                        Object service = RepositoryManager.this.getRetrofitService(serviceClass);
                        return (Observable)RepositoryManager.this.getRetrofitMethod(service, method).invoke(service, args);
                    });
                }
                if (method.getReturnType() == Single.class) {
                    return Single.defer(() -> {
                        Object service = RepositoryManager.this.getRetrofitService(serviceClass);
                        return (Single)RepositoryManager.this.getRetrofitMethod(service, method).invoke(service, args);
                    });
                }
                Object service = RepositoryManager.this.getRetrofitService(serviceClass);
                return RepositoryManager.this.getRetrofitMethod(service, method).invoke(service, args);
            }
        });
    }

    private <T> T getRetrofitService(Class<T> serviceClass) {
        if (this.mRetrofitServiceCache == null) {
            this.mRetrofitServiceCache = this.mCachefactory.build(CacheType.RETROFIT_SERVICE_CACHE);
        }
        Preconditions.checkNotNull(this.mRetrofitServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Object retrofitService = this.mRetrofitServiceCache.get(serviceClass.getCanonicalName());
        if (retrofitService == null) {
            retrofitService = ((Retrofit)this.mRetrofit.get()).create(serviceClass);
            this.mRetrofitServiceCache.put(serviceClass.getCanonicalName(), retrofitService);
        }
        return (T)retrofitService;
    }

    private <T> Method getRetrofitMethod(T service, Method method) throws NoSuchMethodException {
        return service.getClass().getMethod(method.getName(), method.getParameterTypes());
    }

    @Override
    @NonNull
    public synchronized <T> T obtainCacheService(@NonNull Class<T> cacheClass) {
        Preconditions.checkNotNull(cacheClass, "cacheClass == null");
        if (this.mCacheServiceCache == null) {
            this.mCacheServiceCache = this.mCachefactory.build(CacheType.CACHE_SERVICE_CACHE);
        }
        Preconditions.checkNotNull(this.mCacheServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Object cacheService = this.mCacheServiceCache.get(cacheClass.getCanonicalName());
        if (cacheService == null) {
            cacheService = ((RxCache)this.mRxCache.get()).using(cacheClass);
            this.mCacheServiceCache.put(cacheClass.getCanonicalName(), cacheService);
        }
        return (T)cacheService;
    }

    @Override
    public void clearAllCache() {
        ((RxCache)this.mRxCache.get()).evictAll().subscribe();
    }

    @Override
    @NonNull
    public Context getContext() {
        return this.mApplication;
    }
}

