/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.base;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.mvp.IPresenter;
import java.util.List;

public abstract class BaseLazyLoadFragment<P extends IPresenter>
extends BaseFragment<P> {
    private boolean isViewCreated;
    private boolean isVisibleToUser;
    private boolean isDataLoaded;

    protected abstract void lazyLoadData();

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        this.isVisibleToUser = isVisibleToUser;
        this.tryLoadData();
    }

    public void onResume() {
        super.onResume();
        this.isViewCreated = true;
        this.tryLoadData();
    }

    private boolean isParentVisible() {
        Fragment fragment = this.getParentFragment();
        return fragment == null || fragment instanceof BaseLazyLoadFragment && ((BaseLazyLoadFragment)fragment).isVisibleToUser;
    }

    private void dispatchParentVisibleState() {
        FragmentManager fragmentManager = this.getChildFragmentManager();
        List fragments = fragmentManager.getFragments();
        if (fragments.isEmpty()) {
            return;
        }
        for (Fragment child : fragments) {
            if (!(child instanceof BaseLazyLoadFragment) || !((BaseLazyLoadFragment)child).isVisibleToUser) continue;
            ((BaseLazyLoadFragment)child).tryLoadData();
        }
    }

    public void tryLoadData() {
        if (this.isViewCreated && this.isVisibleToUser && this.isParentVisible() && !this.isDataLoaded) {
            this.lazyLoadData();
            this.isDataLoaded = true;
            this.dispatchParentVisibleState();
        }
    }
}

