/*
 * Decompiled with CFR 0.152.
 */
package com.jess.arms.base;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import com.jess.arms.base.delegate.IActivity;
import com.jess.arms.integration.cache.Cache;
import com.jess.arms.integration.cache.CacheType;
import com.jess.arms.integration.lifecycle.ActivityLifecycleable;
import com.jess.arms.mvp.IPresenter;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.ThirdViewUtil;
import com.trello.rxlifecycle2.android.ActivityEvent;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import javax.inject.Inject;

public abstract class BaseActivity<P extends IPresenter>
extends AppCompatActivity
implements IActivity,
ActivityLifecycleable {
    protected final String TAG = this.getClass().getSimpleName();
    private final BehaviorSubject<ActivityEvent> mLifecycleSubject = BehaviorSubject.create();
    private Cache<String, Object> mCache;
    private Unbinder mUnbinder;
    @Inject
    @Nullable
    protected P mPresenter;

    @Override
    @NonNull
    public synchronized Cache<String, Object> provideCache() {
        if (this.mCache == null) {
            this.mCache = ArmsUtils.obtainAppComponentFromContext((Context)this).cacheFactory().build(CacheType.ACTIVITY_CACHE);
        }
        return this.mCache;
    }

    @Override
    @NonNull
    public final Subject<ActivityEvent> provideLifecycleSubject() {
        return this.mLifecycleSubject;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        View view = ThirdViewUtil.convertAutoView(name, context, attrs);
        return view == null ? super.onCreateView(name, context, attrs) : view;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            int layoutResID = this.initView(savedInstanceState);
            if (layoutResID != 0) {
                this.setContentView(layoutResID);
                this.mUnbinder = ButterKnife.bind((Activity)this);
            }
        }
        catch (Exception e) {
            if (e instanceof InflateException) {
                throw e;
            }
            e.printStackTrace();
        }
        this.initData(savedInstanceState);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mUnbinder != null && this.mUnbinder != Unbinder.EMPTY) {
            this.mUnbinder.unbind();
        }
        this.mUnbinder = null;
        if (this.mPresenter != null) {
            this.mPresenter.onDestroy();
        }
        this.mPresenter = null;
    }

    @Override
    public boolean useEventBus() {
        return true;
    }

    @Override
    public boolean useFragment() {
        return true;
    }
}

